#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "syncengine.h"

extern sync_pair *optionpair;

gboolean
on_mainwindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  main_quit();
  return TRUE;
}


void
on_editbutton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  open_syncpairwindow(NULL);
}


gboolean
on_syncpairwin_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  cancel_syncpairwindow();
  return FALSE;
}


void
on_syncpairok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  ok_syncpairwindow();
}


void
on_syncpaircancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  cancel_syncpairwindow();
}


void
on_newpairmenu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  new_pair();
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  main_quit();
}



void
on_aboutmenu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *dialog = create_aboutdialog();
  gtk_widget_show(dialog);
}


void
on_newbutton_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  new_pair();
}


void
on_deletebutton_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  delete_pair();
}


void
on_syncnowbutton_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  sync_now();
}


void
on_localedit_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  open_localplugin_window();
}


void
on_remoteedit_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  open_remoteplugin_window();
}


void
on_editpairitem_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  open_syncpairwindow(NULL);
}


void
on_deletepairitem_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  delete_pair();
}




void
on_calendarcheck_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (optionpair) {
    if (gtk_toggle_button_get_active(togglebutton))
      optionpair->object_types |= SYNC_OBJECT_TYPE_CALENDAR;
    else
      optionpair->object_types &= (~SYNC_OBJECT_TYPE_CALENDAR);
  }
}


void
on_addressbookcheck_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (optionpair) {
    if (gtk_toggle_button_get_active(togglebutton))
      optionpair->object_types |= SYNC_OBJECT_TYPE_PHONEBOOK;
    else
      optionpair->object_types &= (~SYNC_OBJECT_TYPE_PHONEBOOK);
  }
}


void
on_todocheck_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (optionpair) {
    if (gtk_toggle_button_get_active(togglebutton))
      optionpair->object_types |= SYNC_OBJECT_TYPE_TODO;
    else
      optionpair->object_types &= (~SYNC_OBJECT_TYPE_TODO);
  }
}


void
on_logbutton_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  open_logwindow();
}


gboolean
on_logwindow_delete_event              (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  close_logwindow();
  return FALSE;
}


void
on_logokbutton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  close_logwindow();  
}


void
on_logclearbutton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  clear_pairlist_log();
}


void
on_dirlocalremoteradio_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  filter_dir_selected(SYNC_DIR_LOCALTOREMOTE);
}


void
on_dirremotelocalradio_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  filter_dir_selected(SYNC_DIR_REMOTETOLOCAL);
}


void
on_dirbothradio_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  filter_dir_selected(SYNC_DIR_LOCALTOREMOTE|SYNC_DIR_REMOTETOLOCAL);
}


void
on_filterdataentry_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  filter_data_changed(gtk_entry_get_text(GTK_ENTRY(editable)));
}

void
on_hidewinmenu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sync_hide_gui();
}




void
on_syncpairlist_row_activated          (GtkTreeView     *treeview,
                                        GtkTreePath     *path,
                                        GtkTreeViewColumn *column,
                                        gpointer         user_data)
{
  open_syncpairwindow(NULL);
}




void
on_resyncnowbutton_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  resync_now();
}

void
on_item1_activate               (GtkMenuItem     *menuitem,
				 gpointer         user_data) {

}


void
on_showtrayitem_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gboolean value;
  GConfClient *gconf = gconf_client_get_default ();
  value = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
  gconf_client_set_bool(gconf, SYNC_GCONF_PATH"/no_tray_icon", 
			!value, NULL);
  g_object_unref(gconf);
}


void
on_starthiddenitem_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gboolean value;
  GConfClient *gconf = gconf_client_get_default ();
  value = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
  gconf_client_set_bool(gconf, SYNC_GCONF_PATH"/no_gui", 
			value, NULL);
  g_object_unref(gconf);
}


void
on_mainwindow_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
}


gboolean
on_duplicatewin_delete                 (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  GtkWidget *win;

  win = gtk_widget_get_toplevel(GTK_WIDGET(widget));
  sync_duplicate_actionselected(win, SYNC_DUPLICATE_ACTION_KEEPBOTH);
  return TRUE;
}


void
on_duplicate_usefirstbutton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *win;

  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  sync_duplicate_actionselected(win, SYNC_DUPLICATE_ACTION_KEEPFIRST);
}


void
on_duplicate_usesecondbutton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *win;

  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  sync_duplicate_actionselected(win, SYNC_DUPLICATE_ACTION_KEEPSECOND);
}


void
on_duplicate_usebothbutton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *win;

  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  sync_duplicate_actionselected(win, SYNC_DUPLICATE_ACTION_KEEPBOTH);

}


void
on_showresyncitem_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gboolean value;
  GConfClient *gconf = gconf_client_get_default ();
  value = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
  gconf_client_set_bool(gconf, SYNC_GCONF_PATH"/showresync", 
			value, NULL);
  g_object_unref(gconf);
}

