/* Copyright (C) 1999 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "ftpd.h"

int logoutfd = -1;
int logoutmask = 0;

int log_initcontext(char *logname)
{
	return(open(logname, O_APPEND | O_CREAT | O_WRONLY, 0600));
} 

void log_setcontext(int logfd, int logmask)
{
	logoutfd = logfd;
	logoutmask = logmask;
}

void log_addentry(int type, FTPSTATE *peer, char *desc)
{
	if ((logoutfd != -1) && (((logoutmask) & type) == type))
	{
		int currenttime = time(NULL);
		int outlen;
		char *timestr = ctime((time_t *)&currenttime);
		char *outstring;

		int writeresult;
		timestr[strlen(timestr) - 1] = '\0';
		
		switch(type)
		{
			case MYLOG_DACCESS: /* access denied */
				outstring = safe_snprintf("-- %s : %s(%s) : Access Denied to ftp server.\n", timestr, peer->hostname, getipstr(peer->remoteip));
				break;
			case MYLOG_FTRANS: /* transfer log */
				outstring = safe_snprintf("++ %s : %s@%s(%s)/%d : %s\n", 
					timestr, peer->username, peer->hostname, getipstr(peer->remoteip),
					peer->threadnum, desc);
				break;
			case MYLOG_COMMAND: /* command log */
				outstring = safe_snprintf("<< %s : %s@%s(%s)/%d : %s\n", timestr, 
					peer->username, peer->hostname, getipstr(peer->remoteip), 
					peer->threadnum, desc);
				break;
			case MYLOG_RESPONSE: /* response log */
				outstring = safe_snprintf(">> %s : %s@%s(%s)/%d : %s\n", timestr, 
					peer->username, peer->hostname, getipstr(peer->remoteip),
					peer->threadnum, desc);
				break;
			case MYLOG_LOGIN: /* login log */
				outstring = safe_snprintf("!! %s : %s@%s(%s)/%d : %s\n", timestr, 
					peer->username, peer->hostname, getipstr(peer->remoteip),
					peer->threadnum, desc);
				break;
			case MYLOG_INFO: /* info log */  
				outstring = safe_snprintf("** %s : Info - %s\n", timestr, desc); 
				break; 
			case MYLOG_DEBUG: /* debug log */
				outstring = safe_snprintf("dd %s : DEBUG - %s\n", timestr, desc);
				break;
			default:
				outstring = safe_snprintf("uu Unknown log type, report as a bug!\n");
		}		
		
		outlen = strlen(outstring);
		writeresult = write(logoutfd, outstring, outlen);
		
		if (writeresult != outlen)
			ERRORMSGFATAL(strerror(errno));

		freewrapper(outstring);
	}
} 

/* this one assumes it must free desc after doing the log */

void log_giveentry(int type, FTPSTATE *peer, char *desc)
{
	log_addentry(type, peer, desc);
	freewrapper(desc);
}

void debuglog(char *format, ...)
{
#ifdef DEBUG
	char *logmsg;
	va_list ap;
	
	va_start(ap, format);
	logmsg = safe_vsnprintf(format, ap);
	va_end(ap);
	
	log_addentry(MYLOG_DEBUG, NULL, logmsg);
	freewrapper(logmsg);
#endif
}

void log_shutdown(void)
{
	if (logoutfd != -1)
		close(logoutfd);
}

	