/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import viewer.zoomable.Debug;
import viewer.zoomable.named_vector;

public class YaxisTree
extends JTree {
    private static final long serialVersionUID = 3200L;
    private DefaultMutableTreeNode tree_root;
    private List[] leveled_paths;
    private int max_level;
    private int next_expanding_level;
    private List cut_paste_buf;
    private int buf_level;

    public YaxisTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        super(defaultMutableTreeNode);
        this.tree_root = defaultMutableTreeNode;
        super.putClientProperty("JTree.lineStyle", "Angled");
    }

    private void getAllLeavesForNode(named_vector named_vector2, DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode2.isLeaf()) {
                named_vector2.add(defaultMutableTreeNode2.getUserObject());
                continue;
            }
            this.getAllLeavesForNode(named_vector2, defaultMutableTreeNode2);
        }
    }

    public named_vector getNamedVtr(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        named_vector named_vector2 = new named_vector(defaultMutableTreeNode.toString());
        if (!super.isExpanded(treePath)) {
            this.getAllLeavesForNode(named_vector2, defaultMutableTreeNode);
        }
        return named_vector2;
    }

    public void init() {
        this.update_leveled_paths();
        super.setEditable(true);
    }

    public void update_leveled_paths() {
        TreePath treePath;
        int n;
        this.max_level = this.tree_root.getLastLeaf().getLevel();
        if (Debug.isActive()) {
            Debug.println("tree_root(" + this.tree_root + ").level=" + this.tree_root.getLevel());
            Debug.println("last_leaf(" + this.tree_root.getLastLeaf() + ").level=" + this.max_level);
        }
        this.leveled_paths = new ArrayList[this.max_level + 1];
        this.leveled_paths[0] = new ArrayList(1);
        for (n = 1; n <= this.max_level; ++n) {
            this.leveled_paths[n] = new ArrayList();
        }
        Enumeration<TreeNode> enumeration = this.tree_root.breadthFirstEnumeration();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                treePath = new TreePath(defaultMutableTreeNode.getPath());
                this.leveled_paths[defaultMutableTreeNode.getLevel()].add(treePath);
            }
        }
        boolean bl = true;
        this.next_expanding_level = n = 0;
        while (n < this.max_level && bl) {
            Iterator iterator = this.leveled_paths[n].iterator();
            while (iterator.hasNext() && bl) {
                treePath = (TreePath)iterator.next();
                bl = bl && super.isExpanded(treePath);
            }
            ++n;
        }
        this.next_expanding_level = n > this.max_level ? this.max_level : n - 1;
    }

    public boolean isLevelExpandable() {
        return this.next_expanding_level < this.max_level;
    }

    public void expandLevel() {
        if (!this.isLevelExpandable()) {
            return;
        }
        for (TreePath treePath : this.leveled_paths[this.next_expanding_level]) {
            if (!super.isCollapsed(treePath)) continue;
            super.expandPath(treePath);
        }
        this.next_expanding_level = this.next_expanding_level < this.max_level ? ++this.next_expanding_level : this.max_level;
    }

    public boolean isLevelCollapsable() {
        int n = this.next_expanding_level - 1;
        return n >= 0;
    }

    public void collapseLevel() {
        if (!this.isLevelCollapsable()) {
            return;
        }
        int n = this.next_expanding_level - 1;
        for (TreePath treePath : this.leveled_paths[n]) {
            if (!super.isExpanded(treePath)) continue;
            super.collapsePath(treePath);
        }
        this.next_expanding_level = n;
    }

    public void renewCutAndPasteBuffer() {
        this.buf_level = -1;
        if (this.cut_paste_buf != null) {
            this.cut_paste_buf.clear();
        } else {
            this.cut_paste_buf = new ArrayList();
        }
    }

    public boolean isPathLevelSameAsThatOfCutAndPasteBuffer(TreePath treePath) {
        return this.buf_level == this.getLastPathComponentLevel(treePath);
    }

    private int getLastPathComponentLevel(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getLevel();
    }

    public boolean isCutAndPasteBufferUniformlyLeveled(TreePath[] treePathArray) {
        if (treePathArray != null && treePathArray.length > 0) {
            int n = this.getLastPathComponentLevel(treePathArray[0]);
            for (int i = 1; i < treePathArray.length; ++i) {
                if (n == this.getLastPathComponentLevel(treePathArray[i])) continue;
                return false;
            }
            this.buf_level = n;
        }
        return true;
    }

    public void addToCutAndPasteBuffer(TreePath[] treePathArray) {
        if (this.cut_paste_buf != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                this.cut_paste_buf.add(treePathArray[i]);
            }
        }
    }

    public int getLevelOfCutAndPasteBuffer() {
        return this.buf_level;
    }

    public TreePath[] getFromCutAndPasteBuffer() {
        if (this.cut_paste_buf != null) {
            Object[] objectArray = this.cut_paste_buf.toArray();
            TreePath[] treePathArray = new TreePath[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                treePathArray[i] = (TreePath)objectArray[i];
            }
            return treePathArray;
        }
        return null;
    }

    public void clearCutAndPasteBuffer() {
        if (this.cut_paste_buf != null) {
            this.cut_paste_buf.clear();
        }
    }
}

