/*
 * Decompiled with CFR 0.152.
 */
package logformat.trace;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Composite;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import base.drawable.YCoordMap;

public class InputLog {
    private String filespec;
    private long filehandle;
    private int num_topology_returned;

    public InputLog(String string) {
        this.filespec = string;
        boolean bl = this.open();
        if (this.filehandle == 0L) {
            if (bl) {
                System.out.println("trace.InputLog.open() exits normally!");
                System.exit(0);
            } else {
                System.err.println("trace.InputLog.open() fails!\nNo slog2 file is generated due to previous errors.");
                System.exit(1);
            }
        }
        this.num_topology_returned = 0;
    }

    private static native void initIDs();

    public native boolean open();

    public native boolean close();

    public native int peekNextKindIndex();

    public native Category getNextCategory();

    public native YCoordMap getNextYCoordMap();

    public native Primitive getNextPrimitive();

    public native Composite getNextComposite();

    public Kind peekNextKind() {
        if (this.num_topology_returned < 3) {
            return Kind.TOPOLOGY;
        }
        int n = this.peekNextKindIndex();
        switch (n) {
            case -1: {
                return Kind.TOPOLOGY;
            }
            case 0: {
                return Kind.EOF;
            }
            case 1: {
                return Kind.PRIMITIVE;
            }
            case 2: {
                return Kind.COMPOSITE;
            }
            case 3: {
                return Kind.CATEGORY;
            }
            case 4: {
                return Kind.YCOORDMAP;
            }
        }
        System.err.println("trace.InputLog.peekNextKind(): Unknown value, " + n);
        return null;
    }

    public Topology getNextTopology() {
        switch (this.num_topology_returned) {
            case 0: {
                this.num_topology_returned = 1;
                return new Topology(0);
            }
            case 1: {
                this.num_topology_returned = 2;
                return new Topology(1);
            }
            case 2: {
                this.num_topology_returned = 3;
                return new Topology(2);
            }
        }
        System.err.println("All Topology Names have been returned");
        return null;
    }

    public Category getShadowCategoryForTopology(Topology topology) {
        ColorAlpha colorAlpha = new ColorAlpha(ColorAlpha.yellow, 255);
        ColorAlpha colorAlpha2 = new ColorAlpha(ColorAlpha.white, 255);
        ColorAlpha colorAlpha3 = new ColorAlpha(ColorAlpha.white, 191);
        if (topology.isEvent()) {
            Category category = new Category(-1, "Preview_" + topology.toString(), topology, colorAlpha3, 5);
            return category;
        }
        if (topology.isArrow()) {
            Category category = new Category(-2, "Preview_" + topology.toString(), topology, colorAlpha, 5);
            return category;
        }
        if (topology.isState()) {
            Category category = new Category(-3, "Preview_" + topology.toString(), topology, colorAlpha3, 5);
            return category;
        }
        return null;
    }

    static {
        InputLog.initIDs();
    }
}

