/*
 * Decompiled with CFR 0.152.
 */
package viewer.histogram;

import base.drawable.CategoryWeight;
import base.drawable.Topology;
import base.statistics.CategoryTimeBox;
import base.statistics.Summarizable;
import base.statistics.TimeAveBox;
import base.topology.SummaryState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.Border;
import viewer.common.Const;
import viewer.common.Routines;
import viewer.legends.CategoryLabel;
import viewer.zoomable.TimeFormat;

public class InfoPanelForSummary
extends JPanel {
    private static final Component STRUT = Box.createHorizontalStrut(10);
    private static final Component GLUE = Box.createHorizontalGlue();
    private static final String FORMAT = "0.0#";
    private static DecimalFormat nfmt = null;
    private static TimeFormat tfmt = null;
    private static Border Normal_Border = null;

    public InfoPanelForSummary(JTree jTree, String[] stringArray, Summarizable summarizable) {
        Object object;
        super.setLayout(new BoxLayout(this, 1));
        if (nfmt == null) {
            nfmt = (DecimalFormat)NumberFormat.getInstance();
            nfmt.applyPattern(FORMAT);
        }
        if (tfmt == null) {
            tfmt = new TimeFormat();
        }
        if (Normal_Border == null) {
            Normal_Border = BorderFactory.createEtchedBorder();
        }
        Topology topology = summarizable.getTopology();
        int n = summarizable.getStartRowID();
        int n2 = summarizable.getFinalRowID();
        Object object2 = summarizable.getClickedObject();
        String string = " Summary " + topology + " ";
        Border border = null;
        CategoryLabel categoryLabel = null;
        if (object2 instanceof CategoryTimeBox) {
            object = ((CategoryTimeBox)object2).getCategoryWeight();
            categoryLabel = new CategoryLabel(((CategoryWeight)object).getCategory());
            border = BorderFactory.createTitledBorder(Normal_Border, string, 1, 2, Const.FONT, Color.magenta);
        } else {
            categoryLabel = new CategoryLabel(string, topology, SummaryState.ForeColor);
            border = Normal_Border;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(STRUT);
        jPanel.add(categoryLabel);
        jPanel.add(GLUE);
        jPanel.setBorder(border);
        jPanel.setAlignmentX(0.0f);
        object = jPanel.getPreferredSize();
        ((Dimension)object).width = Short.MAX_VALUE;
        jPanel.setMaximumSize((Dimension)object);
        super.add(jPanel);
        TextAreaBuffer textAreaBuffer = new TextAreaBuffer(jTree, stringArray);
        textAreaBuffer.setEndRowIDsText(topology, n, n2);
        if (object2 instanceof CategoryTimeBox) {
            textAreaBuffer.setCategoryTimeBoxText((CategoryTimeBox)object2);
        } else {
            textAreaBuffer.setTimeAveBoxText((TimeAveBox)object2);
        }
        textAreaBuffer.finalized();
        int n3 = textAreaBuffer.getColumnCount();
        int n4 = textAreaBuffer.getRowCount();
        JTextArea jTextArea = new JTextArea(textAreaBuffer.toString());
        int n5 = Routines.getAdjNumOfTextColumns(jTextArea, n3);
        n3 = (int)Math.ceil((double)n5 * 85.0 / 100.0);
        jTextArea.setColumns(n3);
        jTextArea.setRows(n4);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setAlignmentX(0.0f);
        super.add(jScrollPane);
    }

    private class TextAreaBuffer {
        private JTree tree_view;
        private String[] y_colnames;
        private StringBuffer strbuf;
        private String strbuf2str;
        private int num_cols;
        private int num_rows;

        public TextAreaBuffer(JTree jTree, String[] stringArray) {
            this.tree_view = jTree;
            this.y_colnames = stringArray;
            this.strbuf = new StringBuffer();
            this.strbuf2str = null;
            this.num_cols = 0;
            this.num_rows = 0;
        }

        public void finalized() {
            this.strbuf2str = this.strbuf.toString();
            int n = this.getNumOfLines();
            this.num_rows = n <= 3 ? 3 : 4;
        }

        public int getColumnCount() {
            return this.num_cols;
        }

        public int getRowCount() {
            return this.num_rows;
        }

        public String toString() {
            return this.strbuf2str;
        }

        private int getNumOfLines() {
            if (this.strbuf2str != null) {
                int n = 1;
                int n2 = 0;
                int n3 = this.strbuf2str.length();
                while (n2 >= 0 && n2 < n3) {
                    if ((n2 = this.strbuf2str.indexOf(10, n2)) < 0) continue;
                    ++n;
                    ++n2;
                }
                return n;
            }
            return -1;
        }

        public void setEndRowIDsText(Topology topology, int n, int n2) {
            if (topology.isArrow()) {
                int n3;
                StringBuffer stringBuffer = new StringBuffer("Between");
                Object[] objectArray = this.tree_view.getPathForRow(n).getPath();
                for (n3 = 1; n3 < objectArray.length; ++n3) {
                    stringBuffer.append(" " + this.y_colnames[n3 - 1] + "=" + objectArray[n3]);
                }
                if (this.num_cols < stringBuffer.length()) {
                    this.num_cols = stringBuffer.length();
                }
                ++this.num_rows;
                this.strbuf.append(stringBuffer.toString());
                stringBuffer = new StringBuffer("   and   ");
                objectArray = this.tree_view.getPathForRow(n2).getPath();
                for (n3 = 1; n3 < objectArray.length; ++n3) {
                    stringBuffer.append(" " + this.y_colnames[n3 - 1] + "=" + objectArray[n3]);
                }
                if (this.num_cols < stringBuffer.length()) {
                    this.num_cols = stringBuffer.length();
                }
                ++this.num_rows;
                this.strbuf.append("\n" + stringBuffer.toString());
            } else {
                StringBuffer stringBuffer = new StringBuffer("At");
                Object[] objectArray = this.tree_view.getPathForRow(n).getPath();
                for (int i = 1; i < objectArray.length; ++i) {
                    stringBuffer.append(" " + this.y_colnames[i - 1] + "=" + objectArray[i]);
                }
                if (this.num_cols < stringBuffer.length()) {
                    this.num_cols = stringBuffer.length();
                }
                ++this.num_rows;
                this.strbuf.append(stringBuffer.toString());
            }
        }

        private int getPrintStatus(Topology topology) {
            if (topology.isState()) {
                if (SummaryState.isDisplayTypeEqualWeighted()) {
                    return 0;
                }
                if (SummaryState.isDisplayTypeExclusiveRatio()) {
                    return 2;
                }
                return 1;
            }
            return 1;
        }

        public void setCategoryTimeBoxText(CategoryTimeBox categoryTimeBox) {
            CategoryWeight categoryWeight = categoryTimeBox.getCategoryWeight();
            int n = this.getPrintStatus(categoryWeight.getCategory().getTopology());
            ++this.num_rows;
            this.strbuf.append("\n" + CategoryWeight.getPrintTitle(n));
            String string = categoryWeight.toInfoBoxString(n);
            if (this.num_cols < string.length()) {
                this.num_cols = string.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + string);
        }

        public void setTimeAveBoxText(TimeAveBox timeAveBox) {
            StringBuffer stringBuffer = new StringBuffer("Averaged Number of Real Drawables = ");
            stringBuffer.append(nfmt.format(timeAveBox.getAveNumOfRealObjects()));
            if (this.num_cols < stringBuffer.length()) {
                this.num_cols = stringBuffer.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + stringBuffer.toString());
            CategoryTimeBox[] categoryTimeBoxArray = timeAveBox.arrayOfCategoryTimeBoxes();
            CategoryWeight categoryWeight = categoryTimeBoxArray[0].getCategoryWeight();
            int n = this.getPrintStatus(categoryWeight.getCategory().getTopology());
            ++this.num_rows;
            this.strbuf.append("\n" + CategoryWeight.getPrintTitle(n));
            for (int i = 0; i < categoryTimeBoxArray.length; ++i) {
                categoryWeight = categoryTimeBoxArray[i].getCategoryWeight();
                String string = categoryWeight.toInfoBoxString(n);
                if (this.num_cols < string.length()) {
                    this.num_cols = string.length();
                }
                ++this.num_rows;
                this.strbuf.append("\n" + string);
            }
        }
    }
}

