/*
 * Decompiled with CFR 0.152.
 */
package base.statistics;

import base.drawable.CategoryWeight;
import base.drawable.TimeBoundingBox;
import java.awt.Color;
import java.util.Comparator;

public class CategoryTimeBox
extends TimeBoundingBox {
    public static final Comparator INDEX_ORDER = new IndexOrder();
    public static final Comparator INCL_RATIO_ORDER = new InclRatioOrder();
    public static final Comparator EXCL_RATIO_ORDER = new ExclRatioOrder();
    private CategoryWeight twgt;

    public CategoryTimeBox() {
        this.twgt = null;
    }

    public CategoryTimeBox(CategoryWeight categoryWeight) {
        this.twgt = categoryWeight;
    }

    public float getCategoryRatio(boolean bl) {
        return this.twgt.getRatio(bl);
    }

    public Color getCategoryColor() {
        return this.twgt.getCategory().getColor();
    }

    public boolean isCategoryVisiblySearchable() {
        return this.twgt.getCategory().isVisiblySearchable();
    }

    public CategoryWeight getCategoryWeight() {
        return this.twgt;
    }

    private static class ExclRatioOrder
    implements Comparator {
        private ExclRatioOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryTimeBox categoryTimeBox = (CategoryTimeBox)object;
            CategoryTimeBox categoryTimeBox2 = (CategoryTimeBox)object2;
            return CategoryWeight.EXCL_RATIO_ORDER.compare(categoryTimeBox.twgt, categoryTimeBox2.twgt);
        }
    }

    private static class InclRatioOrder
    implements Comparator {
        private InclRatioOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryTimeBox categoryTimeBox = (CategoryTimeBox)object;
            CategoryTimeBox categoryTimeBox2 = (CategoryTimeBox)object2;
            return CategoryWeight.INCL_RATIO_ORDER.compare(categoryTimeBox.twgt, categoryTimeBox2.twgt);
        }
    }

    private static class IndexOrder
    implements Comparator {
        private IndexOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryTimeBox categoryTimeBox = (CategoryTimeBox)object;
            CategoryTimeBox categoryTimeBox2 = (CategoryTimeBox)object2;
            return CategoryWeight.INDEX_ORDER.compare(categoryTimeBox.twgt, categoryTimeBox2.twgt);
        }
    }
}

