/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicScrollBarUI;
import com.sun.java.swing.plaf.metal.MetalBumps;
import com.sun.java.swing.plaf.metal.MetalScrollButton;
import com.sun.java.swing.plaf.metal.MetalUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class MetalScrollBarUI
extends BasicScrollBarUI {
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected MetalBumps bumps;
    protected MetalScrollButton increaseButton;
    protected MetalScrollButton decreaseButton;
    protected static int scrollBarWidth;
    protected ScrollBarListener scrollBarListener = new ScrollBarListener();
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalScrollBarUI();
    }

    public void installUI(JComponent jComponent) {
        scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        if (jComponent.getBackground() == null || jComponent.getBackground() instanceof UIResource) {
            jComponent.setBackground(UIManager.getColor("ScrollBar.background"));
        }
        super.installUI(jComponent);
        this.bumps = new MetalBumps(10, 10, thumbHighlightColor, thumbShadow, thumbColor);
        jComponent.addPropertyChangeListener(this.scrollBarListener);
        this.scrollBarListener.handlePropertyChange(jComponent.getClientProperty(FREE_STANDING_PROP));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.removePropertyChangeListener(this.scrollBarListener);
    }

    protected void configureScrollBarColors() {
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(scrollBarWidth, scrollBarWidth * 3 + 10);
        }
        return new Dimension(scrollBarWidth * 3 + 10, scrollBarWidth);
    }

    protected JButton createDecreaseButton(int n) {
        this.decreaseButton = new MetalScrollButton(n, scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n) {
        this.increaseButton = new MetalScrollButton(n, scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.translate(rectangle.x, rectangle.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                rectangle.width += 2;
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, 0, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 2, 0, rectangle.width - 2, rectangle.height - 1);
                graphics.drawLine(2, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                graphics.drawLine(2, 0, rectangle.width - 2, 0);
                graphics.setColor(highlightColor);
                graphics.drawLine(1, 1, 1, rectangle.height - 2);
                graphics.drawLine(1, 1, rectangle.width - 3, 1);
                graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                rectangle.width -= 2;
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, rectangle.width - 1, 0);
                graphics.drawLine(0, 2, 0, rectangle.height - 2);
                graphics.drawLine(0, rectangle.height - 2, rectangle.width - 1, rectangle.height - 2);
                graphics.drawLine(rectangle.width - 1, 2, rectangle.width - 1, rectangle.height - 1);
                graphics.setColor(highlightColor);
                graphics.drawLine(1, 1, rectangle.width - 2, 1);
                graphics.drawLine(1, 1, 1, rectangle.height - 3);
                graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                rectangle.width += 2;
            }
            graphics.setColor(thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 3, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            this.bumps.setBumpArea(rectangle.width - 6, rectangle.height - 7);
            this.bumps.paintIcon(jComponent, graphics, 3, 4);
            if (!this.isFreeStanding) {
                rectangle.width -= 2;
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            graphics.setColor(thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 3, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 3);
            this.bumps.setBumpArea(rectangle.width - 7, rectangle.height - 6);
            this.bumps.paintIcon(jComponent, graphics, 4, 3);
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected Dimension getMinimumThumbSize() {
        return new Dimension(scrollBarWidth, scrollBarWidth);
    }

    class ScrollBarListener
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(MetalScrollBarUI.FREE_STANDING_PROP)) {
                this.handlePropertyChange(propertyChangeEvent.getNewValue());
            }
        }

        public void handlePropertyChange(Object object) {
            if (object != null) {
                boolean bl = (Boolean)object;
                boolean bl2 = !bl && MetalScrollBarUI.this.isFreeStanding;
                boolean bl3 = bl && !MetalScrollBarUI.this.isFreeStanding;
                MetalScrollBarUI.this.isFreeStanding = bl;
                if (bl2) {
                    this.toFlush();
                } else if (bl3) {
                    this.toFreeStanding();
                }
            } else if (!MetalScrollBarUI.this.isFreeStanding) {
                MetalScrollBarUI.this.isFreeStanding = true;
                this.toFreeStanding();
            }
            if (MetalScrollBarUI.this.increaseButton != null) {
                MetalScrollBarUI.this.increaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
            }
            if (MetalScrollBarUI.this.decreaseButton != null) {
                MetalScrollBarUI.this.decreaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
            }
        }

        protected void toFlush() {
            scrollBarWidth -= 2;
        }

        protected void toFreeStanding() {
            scrollBarWidth += 2;
        }

        ScrollBarListener() {
            MetalScrollBarUI.this = MetalScrollBarUI.this;
        }
    }
}

