/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JToolTip;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ToolTipUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;

public class BasicToolTipUI
extends ToolTipUI
implements Serializable {
    static BasicToolTipUI sharedInstance = new BasicToolTipUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
        this.uninstallListeners(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(jComponent, "ToolTip.border");
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    protected void installListeners(JComponent jComponent) {
    }

    protected void uninstallListeners(JComponent jComponent) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension dimension = jComponent.getSize();
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(jComponent.getForeground());
        graphics.setFont(font);
        graphics.drawString(((JToolTip)jComponent).getTipText(), 3, 2 + fontMetrics.getAscent());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            return new Dimension(6, fontMetrics.getHeight() + 4);
        }
        return new Dimension(fontMetrics.stringWidth(string) + 6, fontMetrics.getHeight() + 4);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }
}

