/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.RootPaneContainer;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.WindowConstants;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Locale;

public class JDialog
extends Dialog
implements WindowConstants,
Accessible,
RootPaneContainer {
    private int defaultCloseOperation = 1;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext;

    public JDialog() {
        this(null, false);
    }

    public JDialog(Frame frame) {
        this(frame, false);
    }

    public JDialog(Frame frame, boolean bl) {
        this(frame, null, bl);
    }

    public JDialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public JDialog(Frame frame, String string, boolean bl) {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame, string, bl);
        this.dialogInit();
    }

    protected void dialogInit() {
        this.enableEvents(64L);
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            switch (this.defaultCloseOperation) {
                case 1: {
                    ((Component)this).setVisible(false);
                    return;
                }
                case 2: {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    return;
                }
            }
        }
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                return;
            }
            finally {
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public void setLocationRelativeTo(Component component) {
        Serializable serializable;
        Serializable serializable2 = null;
        if (component != null) {
            if (component instanceof Window || component instanceof Applet) {
                serializable2 = (Container)component;
            } else {
                serializable = component.getParent();
                while (serializable != null) {
                    if (serializable instanceof Window || serializable instanceof Applet) {
                        serializable2 = serializable;
                        break;
                    }
                    serializable = ((Component)serializable).getParent();
                }
            }
        }
        if (component != null && !component.isShowing() || serializable2 == null || !serializable2.isShowing()) {
            serializable = this.getSize();
            Dimension dimension = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension.width - ((Dimension)serializable).width) / 2, (dimension.height - ((Dimension)serializable).height) / 2);
            return;
        }
        serializable = component.getSize();
        Point point = component.getLocationOnScreen();
        Rectangle rectangle = this.getBounds();
        int n = point.x + (((Dimension)serializable).width - rectangle.width >> 1);
        int n2 = point.y + (((Dimension)serializable).height - rectangle.height >> 1);
        Dimension dimension = this.getToolkit().getScreenSize();
        if (n2 + rectangle.height > dimension.height) {
            n2 = dimension.height - rectangle.height;
            int n3 = n = point.x < dimension.width >> 1 ? point.x + ((Dimension)serializable).width : point.x - rectangle.width;
        }
        if (n + rectangle.width > dimension.width) {
            n = dimension.width - rectangle.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        ((Component)this).setLocation(n, n2);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDialog();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJDialog
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JDialog.this.getTitle() == null) {
                return super.getAccessibleName();
            }
            return JDialog.this.getTitle();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DIALOG;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JDialog.this);
            if (JDialog.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (JDialog.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (JDialog.this.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            Container container = JDialog.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JDialog.this);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JDialog.this);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(JDialog.this, n);
        }

        public Locale getLocale() {
            return JDialog.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return ((Component)JDialog.this).getBackground();
        }

        public void setBackground(Color color) {
            ((Component)JDialog.this).setBackground(color);
        }

        public Color getForeground() {
            return JDialog.this.getForeground();
        }

        public void setForeground(Color color) {
            JDialog.this.setForeground(color);
        }

        public Cursor getCursor() {
            return JDialog.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            ((Component)JDialog.this).setCursor(cursor);
        }

        public Font getFont() {
            return JDialog.this.getFont();
        }

        public void setFont(Font font) {
            ((Component)JDialog.this).setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return JDialog.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return JDialog.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            JDialog.this.setEnabled(bl);
        }

        public boolean isVisible() {
            return JDialog.this.isVisible();
        }

        public void setVisible(boolean bl) {
            ((Component)JDialog.this).setVisible(bl);
        }

        public boolean isShowing() {
            return JDialog.this.isShowing();
        }

        public boolean contains(Point point) {
            return JDialog.this.contains(point);
        }

        public Point getLocationOnScreen() {
            return JDialog.this.getLocationOnScreen();
        }

        public Point getLocation() {
            return JDialog.this.getLocation();
        }

        public void setLocation(Point point) {
            ((Component)JDialog.this).setLocation(point);
        }

        public Rectangle getBounds() {
            return JDialog.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            ((Component)JDialog.this).setBounds(rectangle);
        }

        public Dimension getSize() {
            return JDialog.this.getSize();
        }

        public void setSize(Dimension dimension) {
            ((Component)JDialog.this).setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(JDialog.this, point);
        }

        public boolean isFocusTraversable() {
            return JDialog.this.isFocusTraversable();
        }

        public void requestFocus() {
            JDialog.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            JDialog.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            JDialog.this.removeFocusListener(focusListener);
        }

        AccessibleJDialog() {
            JDialog.this = JDialog.this;
        }
    }
}

