/* manage signals

   Written by Matthias Hensler
   Copyright WSPse 1999+2000
   eMail: wsp@gmx.de

Created: 1999/06/10
Updated: 2000/03/16
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ncurses.h>
#include "mp3creat.h"

#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif

extern void wuuush(int);
extern void lifo_refresh();
extern BOOL select_yesno_box(char *tx);

extern song_typ *lay_top_anchor[2];
extern song_typ *lay_curr_anchor[2];
extern int lay_select_line[2];
extern field_select_typ *top_an, *curr_an;
extern int curr_line;

static void handle_int(int);
static void handle_winch(int);
static void handle_pipe(int);

void act_signal_handler()
{
  signal(SIGINT,   handle_int);
  signal(SIGWINCH, handle_winch);
  signal(SIGHUP,   handle_int);
  signal(SIGPIPE,  handle_pipe);
}

static void handle_int(int sig)
{
  /* got interrupt signal, ask to leave program */
  if(select_yesno_box(_("Interrupt. Leave program?"))) {
    wuuush(2);     /* leave with errorcode 2 (user-termination) */
  }

  /* user send interrupt in error (*lucky*) */
  signal(SIGINT, handle_int);     /* reinstall signal handler */
  signal(SIGHUP, handle_int);
  return;
}

/* resize windows, difficult */
static void handle_winch(int sig)
{
  int maxy,maxx;
  int i;
  
  /* got WINCH signal, so first reinstall signal handler */
  signal(SIGWINCH, handle_winch);

  endwin();
  refresh();
  initscr();

  /* get new window size */
  getmaxyx(stdscr, maxy, maxx);
  
  /* Check for boxes, now out of screen */
  for(i=0;i<=1;i++) {
    while(lay_select_line[i] > maxy-8) {
      lay_select_line[i]--;
      if(lay_curr_anchor[i] && lay_curr_anchor[i]->prev) lay_curr_anchor[i] =
	lay_curr_anchor[i]->prev;
    }
  }
 
  while(curr_line > (maxy>>1)) {
    curr_line--;
    if(curr_an && curr_an->prev) curr_an = curr_an->prev;
  }

  /* Now refresh all windows */
  lifo_refresh();
}

/* catch any sigpipe, caused by external programs */
static void handle_pipe(int sig)
{
  /* got PIPE signal, so first reinstall signal handler */
  signal(SIGPIPE, handle_pipe);
}

