
/*
 * @(#)help.c 1.3 01/01/19
 *
 * Copyright (c) Rich Burridge. All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mptool.h"
#include "interface.h"
#include "support.h"

void
add_help(GtkWidget *parent, gchar *label, gchar *text)
{
    GtkWidget   *widget  = lookup_widget(parent, label);
    GtkTooltips *tooltip = gtk_tooltips_new();

    gtk_tooltips_set_delay(tooltip, 1500);
    gtk_tooltips_set_tip(tooltip, widget, text, "");
}


void
do_show_help(gchar *text)
{
    GtkWidget *help_label;

    if (help_frame_widget == NULL) {
        help_frame_widget = create_help_frame_widget();
    }

    help_label = lookup_widget(F_HELP, "help_text");
    gtk_label_set_text(GTK_LABEL(help_label), text);
    gtk_widget_show(F_HELP);
}
