# copyright (C) 1997-2005 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: printcap.tcl,v 2.10 2005/01/02 00:45:07 jfontain Exp $


namespace eval printerCapability {

    proc parseDatabase {aliasesName defaultName {fileName /etc/printcap}} {        ;# aliases is an array including default as index
        upvar 1 $aliasesName aliases $defaultName default

        if {[catch {set file [open $fileName]}]} return                                                 ;# database is not available
        set find lp
        catch {set find [string trim $::env(PRINTER)]}                                                 ;# favor environment variable
        set new 1
        while {[gets $file line] >= 0} {
            set line [string trim $line]
            if {[string match #* $line]} continue                                                                        ;# comments
            if {$new} {                                                                            ;# format is: name1|...|nameN:\ #
                set index 0
                foreach alias [split [string trim $line {:\\}] |] {
                    set alias [string trim $alias]
                    if {$index == 0} {
                        set name $alias                                                 ;# assume first alias is most important name
                        set aliases($name) {}                                                             ;# initialize aliases list
                    } else {
                        lappend aliases($name) $alias
                    }
                    if {[string equal $alias $find]} {
                        set default $name                                                      ;# only remember main name as default
                    }
                    incr index
                }
            }
            set new [expr {![string match {*\\} $line]}]   ;# if line ends with \, next line is a continuation, else it is a new one
        }
        close $file
    }

}
