/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework;

import java.util.HashMap;
import java.util.Map;
import sharpen.core.framework.DynamicVariable;
import sharpen.core.framework.Environment;

public class Environments {
    private static final DynamicVariable<Environment> _current = DynamicVariable.newInstance(null);

    public static <T> T my(Class<T> service) {
        Environment environment = Environments.current();
        if (environment == null) {
            throw new IllegalStateException();
        }
        return environment.provide(service);
    }

    private static Environment current() {
        return _current.value();
    }

    public static void runWith(Environment environment, Runnable runnable) {
        _current.using(environment, runnable);
    }

    public static Environment newClosedEnvironment(final Object ... bindings) {
        return new Environment(){

            @Override
            public <T> T provide(Class<T> service) {
                Object[] objectArray = bindings;
                int n = bindings.length;
                int n2 = 0;
                while (n2 < n) {
                    Object binding = objectArray[n2];
                    if (service.isInstance(binding)) {
                        return service.cast(binding);
                    }
                    ++n2;
                }
                return null;
            }
        };
    }

    public static Environment newCachingEnvironmentFor(final Environment environment) {
        return new Environment(){
            private final Map<Class<?>, Object> _bindings = new HashMap();

            @Override
            public <T> T provide(Class<T> service) {
                Object existing = this._bindings.get(service);
                if (existing != null) {
                    return service.cast(existing);
                }
                T binding = environment.provide(service);
                if (binding == null) {
                    return null;
                }
                this._bindings.put(service, binding);
                return binding;
            }
        };
    }

    public static Environment newConventionBasedEnvironment(Object ... bindings) {
        return Environments.newCachingEnvironmentFor(Environments.compose(Environments.newClosedEnvironment(bindings), new ConventionBasedEnvironment()));
    }

    public static Environment newConventionBasedEnvironment() {
        return Environments.newCachingEnvironmentFor(new ConventionBasedEnvironment());
    }

    public static Environment compose(final Environment ... environments) {
        return new Environment(){

            @Override
            public <T> T provide(Class<T> service) {
                Environment[] environmentArray = environments;
                int n = environments.length;
                int n2 = 0;
                while (n2 < n) {
                    Environment e = environmentArray[n2];
                    T binding = e.provide(service);
                    if (binding != null) {
                        return binding;
                    }
                    ++n2;
                }
                return null;
            }
        };
    }

    static String defaultImplementationFor(Class service) {
        if (!service.isInterface()) {
            throw new IllegalArgumentException(service + " is not an interface.");
        }
        String packageName = service.getPackage().getName();
        return String.valueOf(packageName) + ".internal." + service.getSimpleName() + "Impl";
    }

    private static final class ConventionBasedEnvironment
    implements Environment {
        private ConventionBasedEnvironment() {
        }

        @Override
        public <T> T provide(Class<T> service) {
            return this.resolve(service);
        }

        private <T> T resolve(Class<T> service) {
            String className = Environments.defaultImplementationFor(service);
            Object binding = this.createInstance(className);
            if (binding == null) {
                throw new IllegalArgumentException("Cant find default implementation for " + service.toString() + ": " + className);
            }
            return service.cast(binding);
        }

        private Object createInstance(String className) {
            try {
                return Class.forName(className).newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

