/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import sharpen.core.framework.ASTUtility;
import sharpen.core.framework.Types;

public class JavadocUtility {
    public static TagElement getJavadocTag(BodyDeclaration node, String tagName) {
        List<TagElement> found = JavadocUtility.getJavadocTags(node, tagName);
        return JavadocUtility.firstTagElementOrNull(found);
    }

    public static TagElement getJavadocTag(PackageDeclaration node, String tagName) {
        List<TagElement> found = JavadocUtility.getJavadocTags(node, tagName);
        return JavadocUtility.firstTagElementOrNull(found);
    }

    private static TagElement firstTagElementOrNull(List<TagElement> tagElements) {
        return tagElements.isEmpty() ? null : tagElements.get(0);
    }

    public static boolean containsJavadoc(BodyDeclaration node, String tag) {
        return JavadocUtility.getJavadocTag(node, tag) != null;
    }

    public static List<TagElement> getJavadocTags(PackageDeclaration node, String tagName) {
        return JavadocUtility.getJavaDocTags(node.getJavadoc(), tagName);
    }

    public static List<TagElement> getJavadocTags(BodyDeclaration node, String tagName) {
        return JavadocUtility.getJavaDocTags(node.getJavadoc(), tagName);
    }

    private static List<TagElement> getJavaDocTags(Javadoc javadoc, String tag) {
        if (javadoc == null) {
            return Collections.emptyList();
        }
        List tags = (List)Types.cast(javadoc.tags());
        return JavadocUtility.collectTags(tags, tag, new ArrayList<TagElement>());
    }

    public static ArrayList<TagElement> collectTags(List<TagElement> tags, String tagName, ArrayList<TagElement> accumulator) {
        for (TagElement element : tags) {
            if (!tagName.equals(element.getTagName())) continue;
            accumulator.add(element);
        }
        return accumulator;
    }

    public static boolean isTextFragment(List<ASTNode> fragments, int index) {
        return fragments.get(index) instanceof TextElement;
    }

    public static String textFragment(List<ASTNode> fragments, int index) {
        return ((TextElement)fragments.get(index)).getText().trim();
    }

    public static List<ASTNode> fragmentsFrom(TagElement element) {
        return (List)Types.cast(element.fragments());
    }

    public static boolean hasSingleTextFragment(TagElement element) {
        List<ASTNode> fragments = JavadocUtility.fragmentsFrom(element);
        return fragments.size() == 1 && JavadocUtility.isTextFragment(fragments, 0);
    }

    public static String singleTextFragmentFrom(TagElement element) {
        if (!JavadocUtility.hasSingleTextFragment(element)) {
            throw new IllegalArgumentException(String.valueOf(ASTUtility.sourceInformation((ASTNode)element)) + ": expecting a single textual argument");
        }
        return JavadocUtility.textFragment(JavadocUtility.fragmentsFrom(element), 0);
    }
}

