/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pictures_status.c,v 1.2 2001/10/18 22:53:12 ostborn Exp $
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "config.h"
#include "mconfig.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mlocale.h"
#include "misc.h"

#include "pictures.h"
#include "generate.h"

#define IM_FILENAME	"status_"
#define IM_FILEEXT	".png"

char *create_pic_status(mconfig *ext_conf, mstate *state, const char *subpath) {
#ifdef HAVE_LIBGD
	int i = 0;
	char filename[255];
	config_output *conf = ext_conf->plugin_conf;
	mlist *l, *first = mlist_init(), *p;
	mstate_web *staweb = state->ext;
	double max_bahr;
	
	static char href[255] = "";
	
	int col_count;
	
	mgraph * graph = malloc(sizeof(mgraph));
	
	p = conf->col_circle;
	
	if (!p) {
		fprintf(stderr, "%s.%d: No colors for the circle found!!\n", __FILE__, __LINE__);
		return NULL;
	}
	
	/* parse the colors for the country pie */
	col_count = 0;
	
	while (p) {
		mdata *data = p->data;
		
		if (!data) break;
		
		if (is_htmltripple(data->key)) {
			col_count++;
		} else {
			fprintf(stderr, "%s.%d: RGB-tripple %s is invalid. not used for the country pie.\n", __FILE__, __LINE__, data->key);
		}
		
		p = p->next;
	}
	
	if (col_count < 2) {
		fprintf(stderr, "%s.%d: Less then 2 colors for the circle found!!\n", __FILE__, __LINE__);
		
		return NULL;
	}
	
	mhash_unfold_sorted_limited(staweb->status_hash, first, 50);
	
	max_bahr = mhash_sumup(staweb->status_hash);
	
	memset(graph, 0, sizeof(mgraph));
	
	graph->name = malloc(strlen(_("Status Codes for")) + strlen(get_month_string(state->month,0)) + 4 + 2 + 1);
	sprintf(graph->name, "%s %s %04d",
		_("Status Codes for"),
		get_month_string(state->month,0),
		state->year
		);
	
	graph->max_x = 1;
	graph->max_z = 0;
	l = first;
	while (l) {
		mdata *data = l->data;
		
		if (data == NULL) {
			l = l->next;
			continue;
		}
		
		if( mdata_get_count(data) / max_bahr < 0.01 || graph->max_z >= 9) 
			break;
		
		graph->max_z++;
		l = l->next;
	}
	graph->filename = NULL;
	graph->height = 0;
	graph->width  = 0;
	graph->pair_names = NULL;
	
	graph->pairs = malloc(sizeof(mgraph_array *) * graph->max_z);
	for (i = 0; i < graph->max_z; i++) {
		graph->pairs[i] = malloc(sizeof(mgraph_array));
		graph->pairs[i]->values = malloc(sizeof(double) * graph->max_x);
	}
	
	l = first; p = conf->col_circle;
	for (i = 0; i < graph->max_z; i++, l = l->next, p = p->next) {
		if (p == NULL) p = conf->col_circle;
		graph->pairs[i]->values[0] = mdata_get_count(l->data);
		graph->pairs[i]->color = p->data->key;
		graph->pairs[i]->name = mhttpcodes(strtol(l->data->key, NULL, 10));
	}

	sprintf(filename, "%s%s%s/%s%04d%02d%s", 
		ext_conf->outputdir ? ext_conf->outputdir : ".",
		subpath ? "/" : "",
		subpath ? subpath : "",
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT);
	
	graph->filename = filename;
	
	create_pie(ext_conf, graph);

	sprintf(href, "<center><img src=\"%s%04d%02d%s\" alt=\"%s\" width=\"%d\" height=\"%d\"></center>\n",
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT,
		_("Status Codes"), graph->width, graph->height);
	
	for (i = 0; i < graph->max_z; i++) {
		free(graph->pairs[i]->values);
		free(graph->pairs[i]);
	}
	
	mlist_free(first);
	free(graph->pairs);
	free(graph->name);
	free(graph);

	return href;
#else
	return NULL;
#endif
}

