/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.10 2001/10/06 16:32:17 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"
#include "mconfig.h"

/* begin of SubList */

int mdata_SubList_to_xml(gzFile *fd, mdata *data) {
#define WR(x,f) \
	gzprintf(fd, "<%s>%"#f"</%s>\n", #x, data->data.sublist.x, #x);
	
	WR(count, d);
	
	gzprintf(fd, "<sublist>\n");
	mlist_write(fd, data->data.sublist.sublist);
	gzprintf(fd, "</sublist>\n");
#undef WR	
	return 0;
}

int mdata_SubList_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_SUBLIST) return -1;
	
	if (data->data.sublist.sublist) mlist_free(data->data.sublist.sublist);
	
	return 0;
}

int mdata_SubList_setdata(mdata *data, const char *str, mlist *list, int count) {
	
	data->key	= malloc(strlen(str)+1);
	assert(data->key);
	strcpy(data->key, str);
	
	data->data.sublist.sublist = list ? list : mlist_init();
	data->data.sublist.count   = count;
	
	if (data->type == M_DATA_TYPE_UNSET) 
		data->type = M_DATA_TYPE_SUBLIST;
	
	return 0;
}

int mdata_SubList_from_xml(mstate_stack *m, int tagtype, mdata *data, int type, const xmlChar *value, const xmlChar **attrs) {
	int i;
	static mdata_values data_values[] = {
		{ "count", M_DATA_FIELDTYPE_LONG, 	NULL },
		{ "sublist", M_DATA_FIELDTYPE_LIST, 	NULL },
		
		{ NULL, M_DATA_FIELDTYPE_UNSET,  NULL}
	};
	
#if 0
	M_DEBUG3(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
		 "|--> '%s' - %s - %d\n", 
		 value, tagtype == 1 ? "open" : (tagtype == 2 ? "close" : (tagtype == 3 ? "text" : "unknown")), type);
	M_DEBUG0(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
		 "o->");
	for (i = 0; i < m->st_depth_max + 2; i++) {
		fprintf(stderr, " %d (%p)", m->st[i].id, m->st[i].data);
	}
	fprintf(stderr, "\n");
#endif 
	switch(tagtype) {
	case M_TAG_BEGIN:
		if (m->st_depth != m->st_depth_max) {
#if 0
			M_DEBUG3(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "cur(depth) != max(depth) [%d - %d]- not my job (%s)\n",
				 m->st_depth, 
				 m->st_depth_max,
				 value);
#endif
			/* hits is a list !! */
			
			m->st_depth++;
			if (mdata_insert_value(m, tagtype, 
					       data_values[m->st[m->st_depth].id - 1].dest, 
					       data_values[m->st[m->st_depth].id - 1].type, 
					       value, attrs)) {
				M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "mdata_read failed: tag %s\n",
					 value);
				return -1;
			}
		} else {
			for (i = 0; data_values[i].string != NULL && 0 != strcmp(data_values[i].string, value); i++)
				;
			if (data_values[i].string != NULL) {
				if (data_values[1].dest == NULL) {
					data->data.sublist.sublist = mlist_init();
					data_values[1].dest = &(data->data.sublist.sublist);
					data_values[0].dest = &(data->data.sublist.count);
				}
				
				m->st_depth_max++;
				m->st_depth++;
				m->st[m->st_depth].id = i + 1;
				m->st[m->st_depth].data = data_values[i].dest;
			} else {
				M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "unknown tag '%s'\n", 
					 value);
				return -1;
			}
		}
		break;
	case M_TAG_END:
		if (m->st_depth != m->st_depth_max) {
#if 0
			M_DEBUG3(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "cur(depth) != max(depth) [%d - %d]- not my job (%s)\n",
				 m->st_depth, 
				 m->st_depth_max,
				 value);
#endif
			m->st_depth++;
			if (mdata_insert_value(m, tagtype, 
					       data_values[m->st[m->st_depth - 1].id - 1].dest, 
					       data_values[m->st[m->st_depth - 1].id - 1].type, 
					       value, attrs)) {
				M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "mdata_read failed: tag %s\n",
					 value);
				return -1;
			}
		} else {
			for (i = 0; data_values[i].string != NULL && 0 != strcmp(data_values[i].string, value); i++)
				;
			if (data_values[i].string != NULL) {
				/* set data */
				if (data->type == M_DATA_TYPE_UNSET) 
					data->type		= M_DATA_TYPE_SUBLIST;
				
				data_values[1].dest = NULL;
				
				m->st[m->st_depth].id = 0;
				m->st_depth_max--;
			} else {
				M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "unknown tag '%s'\n", 
					 value);
				return -1;
			}
		}
		break;
	case M_TAG_TEXT:
		if (m->st_depth != m->st_depth_max) {
#if 0
			M_DEBUG3(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "cur(depth) != max(depth) [%d - %d]- not my job (%s)\n",
				 m->st_depth, 
				 m->st_depth_max,
				 value);
#endif
			
			m->st_depth++;
			if (mdata_insert_value(m, tagtype, 
					       data_values[m->st[m->st_depth - 1].id - 1].dest, 
					       data_values[m->st[m->st_depth - 1].id - 1].type, 
					       value, attrs)) {
				M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "mdata_read failed: tag %s\n",
					 value);
				return -1;
			}
		} else {
			if (mdata_insert_value(m, tagtype, 
					       data_values[m->st[m->st_depth].id - 1].dest, 
					       data_values[m->st[m->st_depth].id - 1].type, 
					       value, attrs)) {
				M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "insert failed for '%s'\n", 
					 value);
				return -1;
			} else {
#if 0
				M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "inserting '%s' for '%s'\n", 
					 value, data_values[m->st[m->st_depth] - 1].string);
#endif
			}
		}
		break;
	default:
		M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "can't handle tagtype '%d'\n", 
			 type);
		return -1;
	}

	return 0;
}



int mdata_SubList_append(mdata *dst, mdata *src) {
	dst->data.sublist.count += src->data.sublist.count;
	
	return 0;
}

mdata *mdata_SubList_init() {
	mdata *data = mdata_init();
	assert(data);
	
	data->key		= NULL;
	data->type		= M_DATA_TYPE_SUBLIST;
	
#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */	
	data->data.sublist.sublist	= NULL;
	data->data.sublist.count	= 0;
	
	return data;
}

mdata *mdata_SubList_copy(mdata *src) {
	mdata *data = mdata_SubList_init();
	assert(data);
	mdata_SubList_setdata(data, src->key, src->data.sublist.sublist, src->data.sublist.count);
	
	return data;
}

mdata *mdata_SubList_create(const char *str, mlist *list) {
	mdata *data = mdata_SubList_init();
	assert(data);
	mdata_SubList_setdata(data, str, list, 1);
	
	return data;
}

/* end of SubList */
