/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.h,v 1.6 2001/12/23 00:12:22 ostborn Exp $
*/

#ifndef _M_DATA_BROKENLINK_H_
#define _M_DATA_BROKENLINK_H_

#include <zlib.h>
#include <libxml/tree.h>

#include "mdatatypes.h"

int	mdata_BrokenLink_to_xml(gzFile *fd, mdata *data);
int     mdata_BrokenLink_from_xml(mstate_stack *m, int tagtype, mdata *data, int type, const xmlChar *value, const xmlChar **attrs);

mdata  *mdata_BrokenLink_create(const char *str, 
	int count, int grouped,
	time_t timestamp, const char *referrer
	);
	
int     mdata_BrokenLink_free(mdata *data);
mdata  *mdata_BrokenLink_copy(mdata *src);
int     mdata_BrokenLink_append(mdata *dst, mdata *src);

int     mdata_BrokenLink_show(const mdata *data);

#endif
