#!/usr/bin/perl

# (c) 2000 Randolph Chung <tausq@debian.org>, GPLv2

# TODO: do something for i18n.... language passed in as a command line param

use strict;

my $linux = '';
my @linux = glob ("/usr/src/kernel-source-*/");
@linux = ("/usr/src/kernel-source/", "/usr/src/linux/", @linux);
my $dir;
foreach $dir (@linux) {
  if (-f "${dir}Makefile") {
    $linux = $dir;
    last;
  }
}
die "Cannot find kernel source." if ($linux eq '');
warn "I: Using \"$linux\" for kernel Makefile's to parse.\n";

my $makefiles = `find $linux -name 'Makefile' -print0`;
my $confighelp = "/usr/src/linux/Documentation/Configure.help";

my (%objs, $f, $lastline, $obj, $tmp);

foreach $f (split(/\000/, $makefiles)) {
  open (F, "<$f") || die "open $f: $!";
  while (<F>) {
    #print ">> $_";
    chomp;
    if (/^obj\-\$\((CONFIG_.+?)\)\s+\+?=\s+([^#]*).*$/) {
    # matches:  obj-$(CONFIG_AZTCD)             += aztcd.o # comment
      my $cfg = $1;
      foreach (split(/\s+/,$2)) {
        push(@{$objs{$cfg}},$_) if ($_ !~ /[\$\\]/);
	# DEBUG printf "%s - %s\n", $cfg, $_ if ($_ !~ /[\$\\]/);
      }
      $lastline = $_;
      next;
    }

    $tmp = "$lastline $_";
    
    if ($tmp =~ /(CONFIG_.+?)\).*?OBJS\s+\+?=\s+([^\.]+?\.o)\s*/) {
      # matches most lines 
      push(@{$objs{$1}}, $2);
    } elsif ($tmp =~ /(CONFIG_.+?)\).*?DIRS.+?=\s+(\S+)/) {
      # matches stuff in net
      push(@{$objs{$1}},"$2.o");
    }
    $lastline = $_;
  }
}

$lastline = undef;
open (H, "<$confighelp") || die $!;
while (<H>) {
  chomp;
  if (/^(CONFIG_.+?)$/) {
    foreach $obj (@{$objs{$1}}) {
      print sprintf("%s=\"%s\"\n", xlat_objname($obj), $lastline);
    }
  }

  $lastline = $_;
  $lastline=~s/`/'/g;
  $lastline=~s/"/'/g;
}
close H;

sub xlat_objname {
  my $obj = shift;

  $obj =~ s/\.[co]$//;
  $obj =~ s/[-,\+]/_/g;
  $obj =~ s/.*\/(.+)/$1/;
  return "summary_$obj";
}
