///////////////////////////////////////////////////////////////////////////////
// $Id: indexfile.cpp,v 1.1.1.1 2003/10/26 20:55:18 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    indexfile.cpp
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Implementation of the index file handler class
*/

// Qt includes
#include <qfile.h>
#include <qtextstream.h>

// local includes
#include "indexfile.h"

///////////////////////////////////////////////////////////////////////////////

IndexFile::IndexFile()
{
}

///////////////////////////////////////////////////////////////////////////////

IndexFile::~IndexFile()
{
}

///////////////////////////////////////////////////////////////////////////////

bool IndexFile::openFile(const QString& filename)
{
	if (filename.isEmpty()) return false;

	QFile file(filename);

	if (!file.open(IO_ReadOnly)) return false;

	m_files.clear();

	QTextStream stream(&file);

	uint linenum = 0;
	QString line = stream.readLine();

	while (!line.isNull())
	{
		linenum++;

		line = line.stripWhiteSpace();

		if (!line.startsWith("#"))
		{
			parseLine(line, linenum, filename);
		}

		line = stream.readLine();
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////

void IndexFile::parseLine(const QString& line, uint linenum, const QString& filename)
{
	if (line.isEmpty()) return;

	if (line.length() < 4)
	{
		qWarning("Parse error in %s line %d: line to short",
		         static_cast<const char*>( QFile::encodeName(filename) ), linenum);
		return;
	}

	bool ok;
	uint index = line.left(2).toInt(&ok, 16);
	if (!ok)
	{
		qWarning("Parse error in %s line %d: invalid index",
		         static_cast<const char*>( QFile::encodeName(filename) ), linenum);
		return;
	}

	QString name = line.mid(3);

	while (m_files.count() < index)
		m_files.append(QString::null);

	if (m_files.count() == index)
	{
		m_files.append(name);
	}
	else
	{
		m_files[index] = name;
	}
}

// End of file

