#ifndef CRATES_H
#define CRATES_H

#include "Tools.h"
#include "StaticDecorationBase.h"

//----------------------------------------------------------------------------
class CrateSurfaces : public SurfacesBase
{
    SURFACES_SINGLETON_OBJECT(CrateSurfaces);

  public:

    //------------------------------------------------------------------------
    enum Type
    {
        T_SMALL = 0,
        T_MEDIUM = 1,
        T_BIG = 2,
        T_BONUS = 3,
        T_FUEL = 4,
        T_TOTAL_NUMBER = 5
    };

    //------------------------------------------------------------------------
    inline const SDL_Surface *getSurface(const Type type) const
    {
        assert(type >= 0);
        assert(type < T_TOTAL_NUMBER);

        return m_crates[type];
    }

    //------------------------------------------------------------------------
    inline Uint16 getCrateWidth(const Type type) const
    {
        return getSurface(type)->w;
    }

    //------------------------------------------------------------------------
    inline Uint16 getCrateHeight(const Type type) const
    {
        return getSurface(type)->h;
    }

  private:

    //------------------------------------------------------------------------
    /// All crate surfaces.
    SDL_Surface *m_crates[T_TOTAL_NUMBER];
};



//----------------------------------------------------------------------------
class Crate : public StaticDecorationBase
{
  public:
    class InitializationData : public StaticDecorationBase::InitializationData
    {
      public:
        InitializationData();
        InitializationData(const XMLNode *crateNode);
        ~InitializationData();

        CrateSurfaces::Type type;
        unsigned score;
        unsigned amount;
    };


    //------------------------------------------------------------------------
    Crate(const InitializationData &init);
    ~Crate();

    //------------------------------------------------------------------------
    static Crate *create(const XMLNode *crateNode);

    inline CrateSurfaces::Type getType() const 
    {
        return m_type;
    }

    inline unsigned getValue() const 
    {
        return m_value;
    }

    inline unsigned getMass() const
    {
        switch (m_type)
        {
        case CrateSurfaces::T_SMALL:
        case CrateSurfaces::T_MEDIUM:
        case CrateSurfaces::T_BIG:
            return (m_type+1)*20;
        default:
            return 0;
        }
    }

    //------------------------------------------------------------------------
    void update();

    //------------------------------------------------------------------------
    void updateSurface();

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    CrateSurfaces::Type m_type;

    /**
     * The bonus score (if m_type == T_BONUS)
     * or the amount of fuel (if m_type == T_FUEL)
     */
    unsigned m_value;
};

#endif //CRATES_H
