#ifndef BLACKHOLE_H
#define BLACKHOLE_H

#include "Tools.h"
#include "StaticDecorationBase.h"

//----------------------------------------------------------------------------
class BlackHoleSurfaces : public SingleSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(BlackHoleSurfaces);
};


//----------------------------------------------------------------------------
class BlackHole : public StaticDecorationBase
{
  public:
    //------------------------------------------------------------------------
    class InitializationData : public StaticDecorationBase::InitializationData
    {
      public:
        InitializationData();
        InitializationData(const XMLNode *blackHoleNode);
        ~InitializationData();

        int gravity;
    };


    //------------------------------------------------------------------------
    BlackHole(const InitializationData &init);
    ~BlackHole();

    //------------------------------------------------------------------------
    static BlackHole *create(const XMLNode *blackHoleNode);

    //------------------------------------------------------------------------
    void addGravityToPlayGround() const;

    inline int getGravity() const
    {
        return m_gravity;
    }

    //------------------------------------------------------------------------
    void update();

    //------------------------------------------------------------------------
    void updateSurface();

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    //------------------------------------------------------------------------
    int m_gravity;
};

#endif //BLACKHOLE_H
