#include <pglabel.h>

#include "StringTokenizer.h"

#include "MissionBriefingMenu.h"

MENU_SINGLETON_INIT(MissionBriefing);

//----------------------------------------------------------------------
MissionBriefingMenu::MissionBriefingMenu()
{
    m_active = false;

    m_widgetList = new PG_WidgetList(NULL, PG_Rect(120, 70, 400, 300));
    m_widgetList->EnableScrollBar(true, PG_SB_VERTICAL);
    m_widgetList->SetTransparency(92);
}

//----------------------------------------------------------------------
MissionBriefingMenu::~MissionBriefingMenu()
{
    ZAP_POINTER(m_widgetList);
}


//----------------------------------------------------------------------
void MissionBriefingMenu::activate(const SDL_Surface *back)
{
    const XMLNode *description =
        GameControlBase::getInstance()->getDescriptionNode();
    if (description && description->hasText())
    {
        m_widgetList->DeleteAll();

        StringTokenizer st(description->getText(), "\n");
        std::string token;
        while (st.hasMoreTokens())
        {
            st.nextToken(token);

            PG_Label* label = new PG_Label(
                NULL, PG_Rect(10, 10, 360, 16), token.c_str());
            m_widgetList->AddWidget(label);
        }

        m_active = true;

        PG_Application::GetApp()->SetBackground((SDL_Surface*)back);
        Show();
    }
}

//----------------------------------------------------------------------
void MissionBriefingMenu::deactivate()
{
    m_active = false;

    Hide();
    PlayGroundMenu::getInstance()->restoreBackground();
}

//----------------------------------------------------------------------
void MissionBriefingMenu::eventShow()
{
    m_widgetList->Show();
    SetInputFocus();
}

//----------------------------------------------------------------------
void MissionBriefingMenu::eventHide()
{
    m_widgetList->Hide();
    ReleaseInputFocus();
}

//----------------------------------------------------------------------
bool MissionBriefingMenu::eventKeyDown(const SDL_KeyboardEvent *key)
{  
    deactivate();
    return true;
}
