#ifndef SINUSTABLE_H
#define SINUSTABLE_H

#include <cassert>

//----------------------------------------------------------------------------
class SinusTable
{
  public:
    SinusTable();
    ~SinusTable();

    static inline double sin(int angle)
    {
        return sm_sinTable[normalize(angle)];
    }

    static inline double cos(int angle)
    {
        return sm_cosTable[normalize(angle)];
    }

    static inline int normalize(int angle)
    {
        while (angle < 0)  angle += 360;
        while (angle >= 360) angle -= 360;

        assert(angle >= 0 && angle < 360);
        return angle;
    }

  private:

    static SinusTable sm_instance;
    static double sm_sinTable[360];
    static double sm_cosTable[360];
};

#endif //SINUSTABLE_H
