#ifndef FILE_H
#define FILE_H

#include <stdint.h>
#include <string>

#include "Tools.h"

//----------------------------------------------------------------------------
class File
{
  public:
    File(const char *name, const char *mode = "r");
    ~File();

    const char *getName() const;

    bool isEOF() const;

    void seek(long offset);
    long tell() const;

    uint8_t readUint8();
    void writeUint8(uint8_t value);
    uint16_t readUint16();
    void writeUint16(uint16_t value);

    size_t read(void *buffer, size_t len);
    size_t write(const void *buffer, size_t len);

    int puts(const char *s);
    int puts(const std::string &s);

    void readline(char *buffer, size_t len);

    //------------------------------------------------------------------------
    static void unlink(const char *name);

    static void copy(const char *src, const char *dst);

    //------------------------------------------------------------------------
    DECLARE_PIMPL;
};

#endif //FILE_H
