#include <pgslider.h>
#include <pgcheckbutton.h>

#include "Exception.h"
#include "SoundInterface.h"
#include "PlayerConfiguration.h"

#include "SoundMenu.h"


#define SOUND_SOUND_TXT_ON "Sound is on"
#define SOUND_SOUND_TXT_OFF "Sound is off"
#define SOUND_MUSIC_TXT_ON "Music is on"
#define SOUND_MUSIC_TXT_OFF "Music is off"

MENU_SINGLETON_INIT(Sound);

//----------------------------------------------------------------------
SoundMenu::SoundMenu()
{
    getWidget(ID_SOUND_MENU_OK)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&SoundMenu::onOk);
    getWidget(ID_SOUND_MENU_CANCEL)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&SoundMenu::onCancel);
    getWidget(ID_SOUND_MENU_SOUND_ONOFF)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&SoundMenu::onSoundCheck);
    getWidget(ID_SOUND_MENU_MUSIC_ONOFF)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&SoundMenu::onMusicCheck);

    PG_Slider* soundSlider =
        (PG_Slider*)getWidget(ID_SOUND_MENU_SOUND_VOLSLID);
    soundSlider->SetEventObject(
        MSG_SLIDE, this, (MSG_CALLBACK_OBJ)&SoundMenu::onSoundSlider);
    soundSlider->SetRange(0, 100);
    m_soundVolume = SoundInterface::getInstance()->getSoundVolume();
    soundSlider->SetPosition(m_soundVolume);

    PG_Slider* musicSlider =
        (PG_Slider*)getWidget(ID_SOUND_MENU_MUSIC_VOLSLID);
    musicSlider->SetEventObject(
        MSG_SLIDE, this, (MSG_CALLBACK_OBJ)&SoundMenu::onMusicSlider);
    musicSlider->SetRange(0, 100);
    m_musicVolume = SoundInterface::getInstance()->getMusicVolume();
    musicSlider->SetPosition(m_musicVolume);

    m_soundEnabled = SoundInterface::getInstance()->isSoundEnabled();
    m_musicEnabled = SoundInterface::getInstance()->isMusicEnabled();

    updateSoundWidgets();
    updateMusicWidgets();


  getWidget(ID_SOUND_MENU_OK)->Show();
  getWidget(ID_SOUND_MENU_CANCEL)->Show();
  getWidget(ID_SOUND_MENU_SOUND_VOLLAB)->Show();
  getWidget(ID_SOUND_MENU_SOUND_VOLSLID)->Show();
  getWidget(ID_SOUND_MENU_SOUND_VOLVAL)->Show();
  getWidget(ID_SOUND_MENU_SOUND_ONOFF)->Show();
  getWidget(ID_SOUND_MENU_MUSIC_VOLLAB)->Show();
  getWidget(ID_SOUND_MENU_MUSIC_VOLSLID)->Show();
  getWidget(ID_SOUND_MENU_MUSIC_VOLVAL)->Show();
  getWidget(ID_SOUND_MENU_MUSIC_ONOFF)->Show();

  m_autoPress = false;
}

//----------------------------------------------------------------------
SoundMenu::~SoundMenu()
{
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(SoundMenu::onOk)
{
    PlayerConfiguration::getInstance()->writeConfiguration();

    MenuManager::getInstance()->changeTo(getPrevious(), true, false);
    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(SoundMenu::onCancel)
{
    m_musicVolume = m_lastMusicVolume;
    m_soundVolume = m_lastSoundVolume;
    m_musicEnabled = m_lastMusicEnabled;
    m_soundEnabled = m_lastSoundEnabled;

    try
    {
        SoundInterface *si = SoundInterface::getInstance();

        si->setMusicVolume(m_musicVolume);
        si->setSoundVolume(m_musicVolume);

        if (m_musicEnabled)
        {
            si->enableMusic();
        }
        else
        {
            si->disableMusic();
        }

        if (m_soundEnabled)
        {
            si->enableSound();
        }
        else
        {
            si->disableSound();
        }

        updateMusicWidgets();
        updateSoundWidgets();
    }
    catch(Exception &e)
    {
        std::cout << "Error resetting sound settings" << std::endl;
    }
    
    MenuManager::getInstance()->changeTo(getPrevious(), true, false);
    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(SoundMenu::onSoundSlider)
{
    m_soundVolume = (Uint8)data;
    char val[5] = "";
    snprintf(val, sizeof(val), "%d%%", m_soundVolume);
    
    try
    {
        SoundInterface::getInstance()->setSoundVolume(m_soundVolume);
    }
    catch(Exception &e)
    {
        std::cout << "Error setting music volume" << std::endl;
        return true;
    }

    getWidget(ID_SOUND_MENU_SOUND_VOLVAL)->SetText(val);
    getWidget(ID_SOUND_MENU_SOUND_VOLVAL)->Redraw();
    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(SoundMenu::onMusicSlider)
{
    m_musicVolume = (Uint8)data;
    char val[5] = "";
    snprintf(val, sizeof(val), "%d%%", m_musicVolume);
    
    try
    {
        SoundInterface::getInstance()->setMusicVolume(m_musicVolume);
    }
    catch(Exception &e)
    {
        std::cout << "Error setting music volume" << std::endl;
        return true;
    }
   
    getWidget(ID_SOUND_MENU_MUSIC_VOLVAL)->SetText(val);
    getWidget(ID_SOUND_MENU_MUSIC_VOLVAL)->Redraw();
    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(SoundMenu::onSoundCheck)
{
    if(m_autoPress) return true;

    PG_CheckButton* check =
        (PG_CheckButton*)getWidget(ID_SOUND_MENU_SOUND_ONOFF);
    m_soundEnabled = check->GetPressed(); //!m_soundEnabled;

    try
    {
        if (m_soundEnabled)
        {
            SoundInterface::getInstance()->enableSound();
        }
        else
        {
            SoundInterface::getInstance()->disableSound();
        }
    }
    catch(Exception &e)
    {
        std::cout << "Error setting sound configuration" << std::endl;
        return true;
    }

    check->SetText(m_soundEnabled ? SOUND_SOUND_TXT_ON : SOUND_SOUND_TXT_OFF);
    check->Redraw();

    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(SoundMenu::onMusicCheck)
{
    if(m_autoPress) return true;

    PG_CheckButton* check =
        (PG_CheckButton*)getWidget(ID_SOUND_MENU_MUSIC_ONOFF);
    m_musicEnabled = check->GetPressed(); //!m_musicEnabled;
    
    try
    {
        if (m_musicEnabled)
        {
            SoundInterface::getInstance()->enableMusic();
        }
        else
        {
            SoundInterface::getInstance()->disableMusic();
        }
    }
    catch(Exception &e)
    {
        std::cout << "Error setting music configuration" << std::endl;
        return true;
    }

    check->SetText(m_musicEnabled ? SOUND_MUSIC_TXT_ON : SOUND_MUSIC_TXT_OFF);
    check->Redraw();

    return true;
}

//----------------------------------------------------------------------
void SoundMenu::eventShow()
{
  getWidget(ID_SOUND_MENU)->Show();

  m_lastSoundVolume = m_soundVolume;
  m_lastMusicVolume = m_musicVolume;
  m_lastSoundEnabled = m_soundEnabled;
  m_lastMusicEnabled = m_musicEnabled;
}

//----------------------------------------------------------------------
void SoundMenu::eventHide()
{
  getWidget(ID_SOUND_MENU)->Hide();
}

//----------------------------------------------------------------------
void SoundMenu::updateMusicWidgets()
{
    m_autoPress = true;

    PG_CheckButton* musicCheck =
        (PG_CheckButton*)getWidget(ID_SOUND_MENU_MUSIC_ONOFF);
    if (m_musicEnabled)
    {
        musicCheck->SetText(SOUND_MUSIC_TXT_ON);
        musicCheck->SetPressed();
    }
    else
    {
        musicCheck->SetText(SOUND_MUSIC_TXT_OFF);
        musicCheck->SetUnpressed();
    }
        
    ((PG_Slider*)getWidget(ID_SOUND_MENU_MUSIC_VOLSLID))->SetPosition(m_musicVolume);
    
    char val[5] = "";
    snprintf(val, sizeof(val), "%d%%", m_musicVolume);
    getWidget(ID_SOUND_MENU_MUSIC_VOLVAL)->SetText(val);
    getWidget(ID_SOUND_MENU_MUSIC_VOLVAL)->Redraw();
    
    m_autoPress = false;
}

//----------------------------------------------------------------------
void SoundMenu::updateSoundWidgets()
{
    m_autoPress = true;

    PG_CheckButton* soundCheck =
        (PG_CheckButton*)getWidget(ID_SOUND_MENU_SOUND_ONOFF);
    if (m_soundEnabled)
    {
        soundCheck->SetText(SOUND_SOUND_TXT_ON);
        soundCheck->SetPressed();
    }
    else
    {
        soundCheck->SetText(SOUND_SOUND_TXT_OFF);
        soundCheck->SetUnpressed();
    }
        
    ((PG_Slider*)getWidget(ID_SOUND_MENU_SOUND_VOLSLID))->SetPosition(m_soundVolume);
    
    char val[5] = "";
    snprintf(val, sizeof(val), "%d%%", m_soundVolume);
    getWidget(ID_SOUND_MENU_SOUND_VOLVAL)->SetText(val);
    getWidget(ID_SOUND_MENU_SOUND_VOLVAL)->Redraw();
    
    m_autoPress = false;
}
