#include "AllObjects.h"
#include "PDUs.h"


//----------------------------------------------------------------------------
PDUBase::PDUBase()
{
}

//----------------------------------------------------------------------------
PDUBase::~PDUBase()
{
}



//----------------------------------------------------------------------------
ObjectPDUBase::ObjectPDUBase()
{
    m_modified = false;
    m_visited = false;
    m_id = 0;
}

//----------------------------------------------------------------------------
ObjectPDUBase::ObjectPDUBase(const ObjectBase *o)
{
    m_modified = false;
    m_visited = false;
    m_id = static_cast<Uint16>(o->getId());
}

//----------------------------------------------------------------------------
ObjectPDUBase::~ObjectPDUBase()
{
}



//----------------------------------------------------------------------------
StaticDecorationObjectPDUBase::StaticDecorationObjectPDUBase()
        : ObjectPDUBase()
{
    m_x = 0;
    m_y = 0;
}

//----------------------------------------------------------------------------
StaticDecorationObjectPDUBase::StaticDecorationObjectPDUBase(const StaticDecorationBase *o)
        : ObjectPDUBase(o)
{
    m_x = o->getPosition().x;
    m_y = o->getPosition().y;
}

//----------------------------------------------------------------------------
StaticDecorationObjectPDUBase::~StaticDecorationObjectPDUBase()
{
}



//----------------------------------------------------------------------------
Uint16 HeaderPDU::sm_pduId = PDUBase::HEADER_PDUID;

Uint16 BarrierPDU::sm_createPDUId = PDUBase::CREATE_BARRIER_PDUID;
Uint16 BlackHolePDU::sm_createPDUId = PDUBase::CREATE_BLACKHOLE_PDUID;
Uint16 CratePDU::sm_createPDUId = PDUBase::CREATE_CRATE_PDUID;
Uint16 GrenadePDU::sm_createPDUId = PDUBase::CREATE_GRENADE_PDUID;
Uint16 GrinderPDU::sm_createPDUId = PDUBase::CREATE_GRINDER_PDUID;
Uint16 MagnetBasePDU::sm_createPDUId = PDUBase::CREATE_MAGNET_PDUID;
Uint16 MissilePDU::sm_createPDUId = PDUBase::CREATE_MISSILE_PDUID;
Uint16 MortarBasePDU::sm_createPDUId = PDUBase::CREATE_MORTAR_PDUID;
Uint16 ParticleFountainBasePDU::sm_createPDUId = PDUBase::CREATE_PARTICLEFOUNTAIN_PDUID;
Uint16 PlatformPDU::sm_createPDUId = PDUBase::CREATE_PLATFORM_PDUID;
Uint16 ProjectileBasePDU::sm_createPDUId = PDUBase::CREATE_PROJECTILE_PDUID;
Uint16 SAMBatteryBasePDU::sm_createPDUId = PDUBase::CREATE_SAMBATTERY_PDUID;
Uint16 ShipPDU::sm_createPDUId = PDUBase::CREATE_SHIP_PDUID;
Uint16 SwitchBasePDU::sm_createPDUId = PDUBase::CREATE_SWITCH_PDUID;
Uint16 TankPDU::sm_createPDUId = PDUBase::CREATE_TANK_PDUID;
Uint16 ThornPDU::sm_createPDUId = PDUBase::CREATE_THORN_PDUID;
Uint16 TurretBasePDU::sm_createPDUId = PDUBase::CREATE_TURRET_PDUID;

Uint16 BarrierPDU::sm_updatePDUId = PDUBase::UPDATE_BARRIER_PDUID;
Uint16 BlackHolePDU::sm_updatePDUId = PDUBase::UPDATE_BLACKHOLE_PDUID;
Uint16 CratePDU::sm_updatePDUId = PDUBase::UPDATE_CRATE_PDUID;
Uint16 GrenadePDU::sm_updatePDUId = PDUBase::UPDATE_GRENADE_PDUID;
Uint16 GrinderPDU::sm_updatePDUId = PDUBase::UPDATE_GRINDER_PDUID;
Uint16 MagnetBasePDU::sm_updatePDUId = PDUBase::UPDATE_MAGNET_PDUID;
Uint16 MissilePDU::sm_updatePDUId = PDUBase::UPDATE_MISSILE_PDUID;
Uint16 MortarBasePDU::sm_updatePDUId = PDUBase::UPDATE_MORTAR_PDUID;
Uint16 ParticleFountainBasePDU::sm_updatePDUId = PDUBase::UPDATE_PARTICLEFOUNTAIN_PDUID;
Uint16 PlatformPDU::sm_updatePDUId = PDUBase::UPDATE_PLATFORM_PDUID;
Uint16 ProjectileBasePDU::sm_updatePDUId = PDUBase::UPDATE_PROJECTILE_PDUID;
Uint16 SAMBatteryBasePDU::sm_updatePDUId = PDUBase::UPDATE_SAMBATTERY_PDUID;
Uint16 ShipPDU::sm_updatePDUId = PDUBase::UPDATE_SHIP_PDUID;
Uint16 SwitchBasePDU::sm_updatePDUId = PDUBase::UPDATE_SWITCH_PDUID;
Uint16 TankPDU::sm_updatePDUId = PDUBase::UPDATE_TANK_PDUID;
Uint16 ThornPDU::sm_updatePDUId = PDUBase::UPDATE_THORN_PDUID;
Uint16 TurretBasePDU::sm_updatePDUId = PDUBase::UPDATE_TURRET_PDUID;

Uint16 DeleteObjectPDU::sm_pduId = DELETE_OBJECT_PDUID;



//----------------------------------------------------------------------------
BarrierPDU::BarrierPDU()
{
    m_orientation = 0;
    m_wh = 0;
    m_activated = 0;
}

//----------------------------------------------------------------------------
BarrierPDU::BarrierPDU(const Barrier *b)
        : StaticDecorationObjectPDUBase(b)
{
    m_orientation = static_cast<Uint8>(b->getOrientation());
    m_wh = static_cast<Uint8>(b->getSize());
    m_activated = static_cast<Uint8>(b->isActivated() ? 0 : 1);
}

//----------------------------------------------------------------------------
BarrierPDU::~BarrierPDU()
{
}

//----------------------------------------------------------------------------
void BarrierPDU::update(const Barrier *b)
{
    do_update(m_activated, static_cast<Uint8>(b->isActivated() ? 1 : 0));
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(BarrierPDU)



//----------------------------------------------------------------------------
BlackHolePDU::BlackHolePDU()
{
}

//----------------------------------------------------------------------------
BlackHolePDU::BlackHolePDU(const BlackHole *b)
        : StaticDecorationObjectPDUBase(b)
{
}

//----------------------------------------------------------------------------
BlackHolePDU::~BlackHolePDU()
{
}

//----------------------------------------------------------------------------
void BlackHolePDU::update(const BlackHole *b)
{
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(BlackHolePDU)



//----------------------------------------------------------------------------
CratePDU::CratePDU()
{
    m_type = 0;
}

//----------------------------------------------------------------------------
CratePDU::CratePDU(const Crate *c)
        : StaticDecorationObjectPDUBase(c)
{
    m_type = static_cast<Uint8>(c->getType());
}

//----------------------------------------------------------------------------
CratePDU::~CratePDU()
{
}

//----------------------------------------------------------------------------
void CratePDU::update(const Crate *c)
{
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(CratePDU)



//----------------------------------------------------------------------------
GrenadePDU::GrenadePDU()
{
    m_x = 0;
    m_y = 0;
}

//----------------------------------------------------------------------------
GrenadePDU::GrenadePDU(const Grenade *g) : ObjectPDUBase(g)
{
    m_x = g->getPosition().x;
    m_y = g->getPosition().y;
}

//----------------------------------------------------------------------------
GrenadePDU::~GrenadePDU()
{
}

//----------------------------------------------------------------------------
void GrenadePDU::update(const Grenade *g)
{
    do_update(m_x, g->getPosition().x);
    do_update(m_y, g->getPosition().y);
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(GrenadePDU)



//----------------------------------------------------------------------------
GrinderPDU::GrinderPDU()
{
    m_x = 0;
    m_y = 0;
    m_frame = 0;
}

//----------------------------------------------------------------------------
GrinderPDU::GrinderPDU(const Grinder *g) : ObjectPDUBase(g)
{
    m_x = g->getPosition().x;
    m_y = g->getPosition().y;
    m_frame = static_cast<Uint8>(g->getCurrentFrame());
}

//----------------------------------------------------------------------------
GrinderPDU::~GrinderPDU()
{
}

//----------------------------------------------------------------------------
void GrinderPDU::update(const Grinder *g)
{
    do_update(m_x, g->getPosition().x);
    do_update(m_y, g->getPosition().y);
    do_update(m_frame, static_cast<Uint8>(g->getCurrentFrame()));
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(GrinderPDU)



//----------------------------------------------------------------------------
MagnetBasePDU::MagnetBasePDU()
{
    m_orientation = 0;
    m_wh = 0;
    m_frame = 0;
}

//----------------------------------------------------------------------------
MagnetBasePDU::MagnetBasePDU(const MagnetBase *m)
        : StaticDecorationObjectPDUBase(m)
{
    m_orientation = static_cast<Uint8>(m->getOrientation());
    m_wh = static_cast<Uint8>(m->getSize());
    m_frame = static_cast<Uint8>(m->getCurrentFrame());
}

//----------------------------------------------------------------------------
MagnetBasePDU::~MagnetBasePDU()
{
}

//----------------------------------------------------------------------------
void MagnetBasePDU::update(const MagnetBase *m)
{
    do_update(m_frame, static_cast<Uint8>(m->getCurrentFrame()));
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(MagnetBasePDU)



//----------------------------------------------------------------------------
MissilePDU::MissilePDU()
{
    m_x = 0;
    m_y = 0;
    m_angle = 0;
    m_thrust = 0;
}

//----------------------------------------------------------------------------
MissilePDU::MissilePDU(const Missile *m) : ObjectPDUBase(m)
{
    m_x = m->getPosition().x;
    m_y = m->getPosition().y;
    m_angle = m->getAngle();
    m_thrust = static_cast<Uint8>(m->isThrust() ? 1 : 0);
}

//----------------------------------------------------------------------------
MissilePDU::~MissilePDU()
{
}

//----------------------------------------------------------------------------
void MissilePDU::update(const Missile *m)
{
    do_update(m_x, m->getPosition().x);
    do_update(m_y, m->getPosition().y);
    do_update(m_angle, m->getAngle());
    do_update(m_thrust, static_cast<Uint8>(m->isThrust() ? 1 : 0));
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(MissilePDU)



//----------------------------------------------------------------------------
MortarBasePDU::MortarBasePDU()
{
    m_orientation = 0;
}

//----------------------------------------------------------------------------
MortarBasePDU::MortarBasePDU(const MortarBase *m)
        : StaticDecorationObjectPDUBase(m)
{
    m_orientation = static_cast<Uint8>(m->getOrientation());
}

//----------------------------------------------------------------------------
MortarBasePDU::~MortarBasePDU()
{
}

//----------------------------------------------------------------------------
void MortarBasePDU::update(const MortarBase *m)
{
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(MortarBasePDU)



//----------------------------------------------------------------------------
ParticleFountainBasePDU::ParticleFountainBasePDU()
{
    m_orientation = 0;
}

//----------------------------------------------------------------------------
ParticleFountainBasePDU::ParticleFountainBasePDU(const ParticleFountainBase *f)
        : StaticDecorationObjectPDUBase(f)
{
    m_orientation = static_cast<Uint8>(f->getOrientation());
}

//----------------------------------------------------------------------------
ParticleFountainBasePDU::~ParticleFountainBasePDU()
{
}

//----------------------------------------------------------------------------
void ParticleFountainBasePDU::update(const ParticleFountainBase *f)
{
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(ParticleFountainBasePDU)



//----------------------------------------------------------------------------
PlatformPDU::PlatformPDU()
{
    m_w = 0;
    m_leftEdge = 0;
    m_rightEdge = 0;
    m_frame = 0;
}

//----------------------------------------------------------------------------
PlatformPDU::PlatformPDU(const Platform *p)
        : StaticDecorationObjectPDUBase(p)
{
    m_w = static_cast<Uint8>(p->getWidth());
    m_leftEdge = static_cast<Uint8>(p->getLeftEdgeType());
    m_rightEdge = static_cast<Uint8>(p->getRightEdgeType());
    m_frame = static_cast<Uint8>(p->getCurrentFrame());
}

//----------------------------------------------------------------------------
PlatformPDU::~PlatformPDU()
{
}

//----------------------------------------------------------------------------
void PlatformPDU::update(const Platform *p)
{
    do_update(m_frame, static_cast<Uint8>(p->getCurrentFrame()));
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(PlatformPDU)



//----------------------------------------------------------------------------
ProjectileBasePDU::ProjectileBasePDU()
{
    m_x = 0;
    m_y = 0;
}

//----------------------------------------------------------------------------
ProjectileBasePDU::ProjectileBasePDU(const ProjectileBase *p) : ObjectPDUBase(p)
{
    m_x = p->getPosition().x;
    m_y = p->getPosition().y;
}

//----------------------------------------------------------------------------
ProjectileBasePDU::~ProjectileBasePDU()
{
}

//----------------------------------------------------------------------------
void ProjectileBasePDU::update(const ProjectileBase *p)
{
    do_update(m_x, p->getPosition().x);
    do_update(m_y, p->getPosition().y);
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(ProjectileBasePDU)



//----------------------------------------------------------------------------
SAMBatteryBasePDU::SAMBatteryBasePDU()
{
    m_orientation = 0;
}

//----------------------------------------------------------------------------
SAMBatteryBasePDU::SAMBatteryBasePDU(const SAMBatteryBase *s)
        : StaticDecorationObjectPDUBase(s)
{
    m_orientation = static_cast<Uint8>(s->getOrientation());
}

//----------------------------------------------------------------------------
SAMBatteryBasePDU::~SAMBatteryBasePDU()
{
}

//----------------------------------------------------------------------------
void SAMBatteryBasePDU::update(const SAMBatteryBase *s)
{
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(SAMBatteryBasePDU)



//----------------------------------------------------------------------------
ShipPDU::ShipPDU()
{
    m_type = 0;
    m_x = 0;
    m_y = 0;
    m_angle = 0;
    m_thrust = 0;
}

//----------------------------------------------------------------------------
ShipPDU::ShipPDU(const Ship *s) : ObjectPDUBase(s)
{
    m_type = static_cast<Uint8>(s->getShipType());
    m_x = s->getPosition().x;
    m_y = s->getPosition().y;
    m_angle = s->getAngle();
    m_thrust = static_cast<Uint8>(s->isThrust() ? 1 : 0);
}

//----------------------------------------------------------------------------
ShipPDU::~ShipPDU()
{
}

//----------------------------------------------------------------------------
void ShipPDU::update(const Ship *s)
{
    do_update(m_x, s->getPosition().x);
    do_update(m_y, s->getPosition().y);
    do_update(m_angle, s->getAngle());
    do_update(m_thrust, static_cast<Uint8>(s->isThrust() ? 1 : 0));
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(ShipPDU)



//----------------------------------------------------------------------------
SwitchBasePDU::SwitchBasePDU()
{
    m_orientation = 0;
}

//----------------------------------------------------------------------------
SwitchBasePDU::SwitchBasePDU(const SwitchBase *s)
        : StaticDecorationObjectPDUBase(s)
{
    m_orientation = static_cast<Uint8>(s->getOrientation());
}

//----------------------------------------------------------------------------
SwitchBasePDU::~SwitchBasePDU()
{
}

//----------------------------------------------------------------------------
void SwitchBasePDU::update(const SwitchBase *s)
{
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(SwitchBasePDU)



//----------------------------------------------------------------------------
TankPDU::TankPDU()
{
    m_x = 0;
    m_y = 0;
}

//----------------------------------------------------------------------------
TankPDU::TankPDU(const Tank *t) : ObjectPDUBase(t)
{
    m_x = t->getPosition().x;
    m_y = t->getPosition().y;
}

//----------------------------------------------------------------------------
TankPDU::~TankPDU()
{
}

//----------------------------------------------------------------------------
void TankPDU::update(const Tank *t)
{
    do_update(m_x, t->getPosition().x);
    do_update(m_y, t->getPosition().y);
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(TankPDU)



//----------------------------------------------------------------------------
ThornPDU::ThornPDU()
{
    m_orientation = 0;
    m_size = 0;
}

//----------------------------------------------------------------------------
ThornPDU::ThornPDU(const Thorn *t)
        : StaticDecorationObjectPDUBase(t)
{
    m_orientation = static_cast<Uint8>(t->getOrientation());
    m_size = static_cast<Uint16>(t->getSize());
}

//----------------------------------------------------------------------------
ThornPDU::~ThornPDU()
{
}

//----------------------------------------------------------------------------
void ThornPDU::update(const Thorn *t)
{
    do_update(m_size, static_cast<Uint16>(t->getSize()));
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(ThornPDU)



//----------------------------------------------------------------------------
TurretBasePDU::TurretBasePDU()
{
    m_orientation = 0;
    m_type = 0;
}

//----------------------------------------------------------------------------
TurretBasePDU::TurretBasePDU(const TurretBase *t)
        : StaticDecorationObjectPDUBase(t)
{
    m_orientation = static_cast<Uint8>(t->getOrientation());
    m_type = static_cast<Uint8>(t->getType());
}

//----------------------------------------------------------------------------
TurretBasePDU::~TurretBasePDU()
{
}

//----------------------------------------------------------------------------
void TurretBasePDU::update(const TurretBase *t)
{
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(TurretBasePDU)



//----------------------------------------------------------------------------
HeaderPDU::HeaderPDU()
{
    m_version = 1;
    m_length = 0;
}

//----------------------------------------------------------------------------
HeaderPDU::~HeaderPDU()
{
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(HeaderPDU)



//----------------------------------------------------------------------------
DeleteObjectPDU::~DeleteObjectPDU()
{
}

//----------------------------------------------------------------------------
DECLARE_PDU_VISITOR_API_BODY(DeleteObjectPDU)



//----------------------------------------------------------------------------
PDUVisitor::PDUVisitor()
{
}

//----------------------------------------------------------------------------
PDUVisitor::~PDUVisitor()
{
}



//----------------------------------------------------------------------------
PDUConstVisitor::PDUConstVisitor()
{
}

//----------------------------------------------------------------------------
PDUConstVisitor::~PDUConstVisitor()
{
}
