#ifndef MATRIX_H
#define MATRIX_H

#include <cassert>

#include "Tools.h"

//----------------------------------------------------------------------------
template <class T>
class Matrix
{
  public:
    //------------------------------------------------------------------------
    Matrix()
    {
        m_xSize = 0;
        m_ySize = 0;
        m_matrix = NULL;
    }

    Matrix(const Matrix &other)
    {
        m_matrix = NULL;
        operator=(other);
    }

    ~Matrix()
    {
        ZAP_ARRAY(m_matrix);
    }

    //------------------------------------------------------------------------
    void resize(unsigned x, unsigned y)
    {
        ZAP_ARRAY(m_matrix);

        m_xSize = x;
        m_ySize = y;
        m_matrix = new T[m_xSize * m_ySize];
    }

    void resize(unsigned x, unsigned y, T value)
    {
        resize(x, y);
        setAll(value);
    }

    //------------------------------------------------------------------------
    unsigned getXSize() const
    {
        return m_xSize;
    }

    unsigned getYSize() const
    {
        return m_ySize;
    }

    //------------------------------------------------------------------------
    T get(unsigned x, unsigned y) const
    {
        assert(x < m_xSize);
        assert(y < m_ySize);
        return m_matrix[y*m_xSize + x];
    }

    void set(unsigned x, unsigned y, T value)
    {
        assert(x < m_xSize);
        assert(y < m_ySize);
        m_matrix[y*m_xSize + x] = value;
    }

    void setAll(T value)
    {
        unsigned yOffset = 0;
        for (unsigned y=0; y<m_ySize; y++)
        {
            for (unsigned x=0; x<m_xSize; x++)
            {
                m_matrix[yOffset + x] = value;
            }
            yOffset += m_xSize;
        }
    }

    //------------------------------------------------------------------------
    Matrix &operator=(const Matrix &other)
    {
        resize(other.m_xSize, other.m_ySize);
        for (unsigned y=0; y<m_ySize; y++)
        {
            for (unsigned x=0; x<m_xSize; x++)
            {
                set(x, y, other.get(x, y));
            }
        }

        return *this;
    }

  protected:

    //------------------------------------------------------------------------
    unsigned m_xSize;
    unsigned m_ySize;

    T* m_matrix;
};

#endif //MATRIX_H
