#ifndef LEVELREADER_H
#define LEVELREADER_H

#include <list>
#include <string>


//----------------------------------------------------------------------------
class LevelReader
{
    typedef std::list<std::string> Levels;

  public:
    typedef Levels::iterator iterator;
    typedef Levels::const_iterator const_iterator;

    //------------------------------------------------------------------------
    LevelReader();
    ~LevelReader();

    //------------------------------------------------------------------------
    void init(const char *mission);

    //------------------------------------------------------------------------
    inline const std::string &getMission() const
    {
        return m_mission;
    }

    //------------------------------------------------------------------------
    inline bool empty() const { return m_levels.empty(); }
    inline size_t size() const { return m_levels.size(); }

    inline iterator begin() { return m_levels.begin(); }
    inline iterator end() { return m_levels.end(); }

    inline const_iterator begin() const { return m_levels.begin(); }
    inline const_iterator end() const { return m_levels.end(); }

  private:
    //------------------------------------------------------------------------
    std::string m_mission;
    Levels m_levels;
};


//----------------------------------------------------------------------------
class MissionReader
{
    //------------------------------------------------------------------------
    typedef std::pair<std::string, std::string> Entry;
    typedef std::list<Entry> Missions;

  public:
    typedef Missions::iterator iterator;
    typedef Missions::const_iterator const_iterator;

    //------------------------------------------------------------------------
    MissionReader();
    ~MissionReader();

    //------------------------------------------------------------------------
    void init();

    //------------------------------------------------------------------------
    inline bool empty() const { return m_missions.empty(); }
    inline size_t size() const { return m_missions.size(); }

    iterator begin() { return m_missions.begin(); }
    iterator end() { return m_missions.end(); }

    const_iterator begin() const { return m_missions.begin(); }
    const_iterator end() const { return m_missions.end(); }

  private:
    Missions m_missions;
};

#endif //LEVELREADER_H
