/*
 *	$Id$
 */

#include  "mc_wall_pic.h"

#include  <kiklib/kik_str.h>
#include  <kiklib/kik_mem.h>		/* free */
#include  <glib.h>
#include  <c_intl.h>

#include  "mc_io.h"


/* --- static functions --- */

static GtkWidget *  entry ;
static char *  old_wall_pic = NULL;
static int is_changed;


/* --- static functions --- */

static gint
file_sel_cancel_clicked(
	GtkObject *  object
	)
{
	gtk_widget_destroy( GTK_WIDGET(object)) ;
	
	return  FALSE ;
}

static gint
file_sel_ok_clicked(
	GtkObject *  object
	)
{
	gtk_entry_set_text( GTK_ENTRY(entry) ,
		gtk_file_selection_get_filename( GTK_FILE_SELECTION( object))) ;
	gtk_widget_destroy( GTK_WIDGET(object)) ;

	return  TRUE ;
}

static gint
button_clicked(
	GtkObject *  object
	)
{
	GtkWidget *  file_sel ;

	file_sel = gtk_file_selection_new( "Wall Paper") ;
	gtk_widget_show( GTK_WIDGET(file_sel)) ;

	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION(file_sel)->ok_button) ,
		"clicked" , GTK_SIGNAL_FUNC(file_sel_ok_clicked) , GTK_OBJECT(file_sel)) ;

	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION(file_sel)->cancel_button) ,
		"clicked" , GTK_SIGNAL_FUNC(file_sel_cancel_clicked) , GTK_OBJECT(file_sel)) ;
		
	return  TRUE ;
}


/* --- global functions --- */

GtkWidget *
mc_wall_pic_config_widget_new(void)
{
	GtkWidget *  hbox ;
	GtkWidget *  button ;
	char *  wall_pic ;

	wall_pic = mc_get_str_value( "wall_picture") ;
	
	hbox = gtk_hbox_new( FALSE , 5) ;
	gtk_widget_show(hbox) ;
 
#if 0
	label = gtk_label_new(_("Picture")) ;
	gtk_widget_show( label) ;
	gtk_box_pack_start(GTK_BOX(hbox) , label , FALSE , FALSE , 5) ;
#endif
	
	entry = gtk_entry_new() ;
	gtk_widget_show( entry) ;
	gtk_box_pack_start( GTK_BOX(hbox) , entry , TRUE , TRUE , 2) ;
	gtk_entry_set_text( GTK_ENTRY(entry) , wall_pic) ;
	
	button = gtk_button_new_with_label( _(" Select ")) ;
	gtk_widget_show(button) ;
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , GTK_SIGNAL_FUNC(button_clicked) , NULL) ;
	gtk_box_pack_start(GTK_BOX(hbox) , button , FALSE , FALSE , 0) ;

	old_wall_pic = wall_pic ;
	is_changed = 0 ;

	return  hbox ;
}

void
mc_update_wall_pic(void)
{
	char *  new_wall_pic ;

	new_wall_pic = gtk_editable_get_chars(GTK_EDITABLE(entry), 0, -1);

	if( strcmp( old_wall_pic , new_wall_pic) != 0) is_changed = 1;

	if( is_changed)
	{
		mc_set_str_value( "wall_picture" , new_wall_pic) ;
		free( old_wall_pic) ;
		old_wall_pic = new_wall_pic ;
	}else{
		free( new_wall_pic);
	}
}

void
mc_wall_pic_none(void)
{
	free( old_wall_pic);
	old_wall_pic = strdup( "");

	mc_set_str_value( "wall_picture" , "") ;
}

