/****************************************************************************
* MeshLab                                                           o o     *
* An extendible mesh processor                                    o     o   *
*                                                                _   O  _   *
* Copyright(C) 2005, 2006                                          \/)\/    *
* Visual Computing Lab                                            /\/|      *
* ISTI - Italian National Research Council                           |      *
*                                                                    \      *
* All rights reserved.                                                      *
*                                                                           *
* This program is free software; you can redistribute it and/or modify      *
* it under the terms of the GNU General Public License as published by      *
* the Free Software Foundation; either version 2 of the License, or         *
* (at your option) any later version.                                       *
*                                                                           *
* This program is distributed in the hope that it will be useful,           *
* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
* GNU General Public License (http://www.gnu.org/licenses/gpl.txt)          *
* for more details.                                                         *
*                                                                           *
****************************************************************************/

#ifndef __MATERIALS_H__
#define __MATERIALS_H__

#define NUM_MATERIALS 22

enum mat_name {
  brass, bronze, polished_bronze, chrome, copper, polished_copper,
  gold, polished_gold, pewter, silver, polished_silver, emerald,
  jade, obsidian, pearl, ruby, turquoise, black_plastic,
  black_rubber, sand, light, none
}; // following materials.h matrix order

// ambient
// diffuse
// specular
// shininess

const GLfloat Mats[NUM_MATERIALS][14] = {
/*   {//transp */
/* 	0.0, 0.0, 0.0, 0.0, */
/* 	0.0, 0.0, 0.0, 0.0, */
/* 	0.0, 0.0, 0.0, 0.0, */
/* 	1.0 */
/* }, */

/*   {//chocolate */
/* 	0.000000, 0.00000, 0.000000, 1.000000, */
/* 	0.80000, 0.40000, 0.20000, 1.000000, */
/* 	0.50000, 0.50000, 0.500000, 1.000000, */
/* 	100.000000 */
/*   }, */
/*   {// No Material */
/* 	0.0000, 0.000, 0.0000, 1.000000, */
/* 	0.00000, 0.0000, 0.0000, 1.000000, */
/* 	0.0000, 0.0000, 0.00000, 1.000000, */
/* 	0.000000 */
/*   }, */

  {//silver
	0.192250, 0.192250, 0.192250, 1.000000,
	0.507540, 0.507540, 0.507540, 1.000000,
	0.508273, 0.508273, 0.508273, 1.000000,
	51.200001
},
  {//gold
	0.247250, 0.199500, 0.074500, 1.000000,
	0.751640, 0.606480, 0.226480, 1.000000,
	0.628281, 0.555802, 0.366065, 1.000000,
	51.200001
},
  {//turquoise
	0.100000, 0.187250, 0.174500, 0.800000,
	0.396000, 0.741510, 0.691020, 0.800000,
	0.297254, 0.308290, 0.306678, 0.800000,
	12.800000
},
  {//ruby
	0.174500, 0.011750, 0.011750, 0.550000,
	0.614240, 0.041360, 0.041360, 0.550000,
	0.727811, 0.626959, 0.626959, 0.550000,
	76.800003
},
  {//brass
	0.329412, 0.223529, 0.027451, 1.000000,
	0.780392, 0.568627, 0.113725, 1.000000,
	0.992157, 0.941176, 0.807843, 1.000000,
	27.897400
  },
  {// No Material
	0.0000, 0.000, 0.0000, 1.000000,
	0.00000, 0.0000, 0.0000, 1.000000,
	0.0000, 0.0000, 0.00000, 1.000000,
	0.000000
  },
  {// Quality Map
	0.0000, 0.000, 0.0000, 1.000000,
	0.00000, 0.0000, 0.0000, 1.000000,
	0.0000, 0.0000, 0.00000, 1.000000,
	99.000000
  },
  {// Normal Map
	0.0000, 0.000, 0.0000, 1.000000,
	0.00000, 0.0000, 0.0000, 1.000000,
	0.0000, 0.0000, 0.00000, 1.000000,
	98.000000
  },
/*   { // sand */
/*     0.2,  0.2,  0.2,  1.0, */
/*     0.92, 0.72, 0.21, 1.0, */
/*     0.05, 0.05, 0.05, 1.0, */
/*     1.0 */
/*   }, */
/*   {//bronze */
/* 	0.212500, 0.127500, 0.054000, 1.000000, */
/* 	0.714000, 0.428400, 0.181440, 1.000000, */
/* 	0.393548, 0.271906, 0.166721, 1.000000, */
/* 	25.600000 */
/* }, */
/*   {//polished_bronze */
/* 	0.250000, 0.148000, 0.064750, 1.000000, */
/* 	0.400000, 0.236800, 0.103600, 1.000000, */
/* 	0.774597, 0.458561, 0.200621, 1.000000, */
/* 	76.800003 */
/* }, */
  {//chrome
	0.250000, 0.250000, 0.250000, 1.000000,
	0.400000, 0.400000, 0.400000, 1.000000,
	0.774597, 0.774597, 0.774597, 1.000000,
	76.800003
},
  {//copper
	0.191250, 0.073500, 0.022500, 1.000000,
	0.703800, 0.270480, 0.082800, 1.000000,
	0.256777, 0.137622, 0.086014, 1.000000,
	12.800000
},
  {//polished_copper
	0.229500, 0.088250, 0.027500, 1.000000,
	0.550800, 0.211800, 0.066000, 1.000000,
	0.580594, 0.223257, 0.069570, 1.000000,
	51.200001
},

  {//polished_gold
	0.247250, 0.224500, 0.064500, 1.000000,
	0.346150, 0.314300, 0.090300, 1.000000,
	0.797357, 0.723991, 0.208006, 1.000000,
	83.199997
},
  {//pewter
	0.105882, 0.058824, 0.113725, 1.000000,
	0.427451, 0.470588, 0.541176, 1.000000,
	0.333333, 0.333333, 0.521569, 1.000000,
	9.846150
},

  {//polished_silver
	0.231250, 0.231250, 0.231250, 1.000000,
	0.277500, 0.277500, 0.277500, 1.000000,
	0.773911, 0.773911, 0.773911, 1.000000,
	89.599998
},
  {//emerald
	0.021500, 0.174500, 0.021500, 0.550000,
	0.075680, 0.614240, 0.075680, 0.550000,
	0.633000, 0.727811, 0.633000, 0.550000,
	76.800003
},
  {//jade
	0.135000, 0.222500, 0.157500, 0.950000,
	0.540000, 0.890000, 0.630000, 0.950000,
	0.316228, 0.316228, 0.316228, 0.950000,
	12.800000
},
  {//obsidian
	0.053750, 0.050000, 0.066250, 0.820000,
	0.182750, 0.170000, 0.225250, 0.820000,
	0.332741, 0.328634, 0.346435, 0.820000,
	38.400002
},
  {//pearl
	0.250000, 0.207250, 0.207250, 0.922000,
	1.000000, 0.829000, 0.829000, 0.922000,
	0.296648, 0.296648, 0.296648, 0.922000,
	11.264000
},


  {//black_plastic
	0.000000, 0.000000, 0.000000, 1.000000,
	0.010000, 0.010000, 0.010000, 1.000000,
	0.500000, 0.500000, 0.500000, 1.000000,
	32.000000
},
  {//black_rubber
	0.020000, 0.020000, 0.020000, 1.000000,
	0.010000, 0.010000, 0.010000, 1.000000,
	0.400000, 0.400000, 0.400000, 1.000000,
	10.000000
  },

  {//light
	0.10000, 0.10000, 0.10000, 1.00000,
	0.10000, 0.10000, 0.10000, 1.00000,
	0.10000, 0.10000, 0.10000, 1.00000,
	12.000000
  },
  {//none
	0.0000, 0.0000, 0.0000, 1.00000,
	0.0000, 0.0000, 0.0000, 1.00000,
	0.0000, 0.0000, 0.0000, 1.00000,
	0.000000
  }





};

#endif
