#ifndef _RADEON_CHIPSET_H
#define _RADEON_CHIPSET_H
/* Including xf86PciInfo.h introduces a bunch of errors...
 */

/* General chip classes:
 * r100 includes R100, RV100, RV200, RS100, RS200, RS250.
 * r200 includes R200, RV250, RV280, RS300.
 * r300 includes R300, RV350, RV370.
 * (RS* denotes IGP)
 */
#define PCI_CHIP_RV380_3150		0x3150
#define PCI_CHIP_RV380_3152		0x3152
#define PCI_CHIP_RV380_3154		0x3154
#define PCI_CHIP_RV380_3E50		0x3E50
#define PCI_CHIP_RV380_3E54		0x3E54
#define PCI_CHIP_RS100_4136		0x4136
#define PCI_CHIP_RS200_4137		0x4137
#define PCI_CHIP_R300_AD		0x4144
#define PCI_CHIP_R300_AE		0x4145
#define PCI_CHIP_R300_AF		0x4146
#define PCI_CHIP_R300_AG		0x4147
#define PCI_CHIP_R350_AH                0x4148
#define PCI_CHIP_R350_AI                0x4149
#define PCI_CHIP_R350_AJ                0x414A
#define PCI_CHIP_R350_AK                0x414B
#define PCI_CHIP_RV350_AP               0x4150
#define PCI_CHIP_RV350_AQ               0x4151
#define PCI_CHIP_RV350_AR               0x4152
#define PCI_CHIP_RV350_AS               0x4153
#define PCI_CHIP_RV350_AT               0x4154
#define PCI_CHIP_RV350_AU		0x4155
#define PCI_CHIP_RV350_AV               0x4156
#define PCI_CHIP_RS250_4237		0x4237
#define PCI_CHIP_R200_BB		0x4242
#define PCI_CHIP_R200_BC		0x4243
#define PCI_CHIP_RS100_4336		0x4336
#define PCI_CHIP_RS200_4337		0x4337
#define PCI_CHIP_RS250_4437		0x4437
#define PCI_CHIP_RV250_If		0x4966
#define PCI_CHIP_RV250_Ig		0x4967
#define PCI_CHIP_R420_JH		0x4A48
#define PCI_CHIP_R420_JI		0x4A49
#define PCI_CHIP_R420_JJ		0x4A4A
#define PCI_CHIP_R420_JK		0x4A4B
#define PCI_CHIP_R420_JL		0x4A4C
#define PCI_CHIP_R420_JM		0x4A4D
#define PCI_CHIP_R420_JN		0x4A4E
#define PCI_CHIP_R420_JO		0x4A4F
#define PCI_CHIP_R420_JP		0x4A50
#define PCI_CHIP_R420_JT		0x4A54
#define PCI_CHIP_R481_4B49		0x4B49
#define PCI_CHIP_R481_4B4A		0x4B4A
#define PCI_CHIP_R481_4B4B		0x4B4B
#define PCI_CHIP_R481_4B4C		0x4B4C
#define PCI_CHIP_RADEON_LW		0x4C57
#define PCI_CHIP_RADEON_LX		0x4C58
#define PCI_CHIP_RADEON_LY		0x4C59
#define PCI_CHIP_RADEON_LZ		0x4C5A
#define PCI_CHIP_RV250_Ld		0x4C64
#define PCI_CHIP_RV250_Lf		0x4C66
#define PCI_CHIP_RV250_Lg		0x4C67
#define PCI_CHIP_R300_ND		0x4E44
#define PCI_CHIP_R300_NE		0x4E45
#define PCI_CHIP_R300_NF		0x4E46
#define PCI_CHIP_R300_NG		0x4E47
#define PCI_CHIP_R350_NH                0x4E48
#define PCI_CHIP_R350_NI                0x4E49  
#define PCI_CHIP_R360_NJ                0x4E4A  
#define PCI_CHIP_R350_NK                0x4E4B  
#define PCI_CHIP_RV350_NP               0x4E50
#define PCI_CHIP_RV350_NQ               0x4E51
#define PCI_CHIP_RV350_NR               0x4E52
#define PCI_CHIP_RV350_NS               0x4E53
#define PCI_CHIP_RV350_NT               0x4E54
#define PCI_CHIP_RV350_NV               0x4E56
#define PCI_CHIP_RADEON_QD		0x5144
#define PCI_CHIP_RADEON_QE		0x5145
#define PCI_CHIP_RADEON_QF		0x5146
#define PCI_CHIP_RADEON_QG		0x5147
#define PCI_CHIP_R200_QH		0x5148
#define PCI_CHIP_R200_QL		0x514C
#define PCI_CHIP_R200_QM		0x514D
#define PCI_CHIP_RV200_QW		0x5157
#define PCI_CHIP_RV200_QX		0x5158
#define PCI_CHIP_RADEON_QY		0x5159
#define PCI_CHIP_RADEON_QZ		0x515A
#define PCI_CHIP_RN50_515E		0x515E
#define PCI_CHIP_RV370_5460		0x5460
#define PCI_CHIP_RV370_5462		0x5462
#define PCI_CHIP_RV370_5464		0x5464
#define PCI_CHIP_R423_UH		0x5548
#define PCI_CHIP_R423_UI		0x5549
#define PCI_CHIP_R423_UJ		0x554A
#define PCI_CHIP_R423_UK		0x554B
#define PCI_CHIP_R430_554C		0x554C
#define PCI_CHIP_R430_554D		0x554D
#define PCI_CHIP_R430_554E		0x554E
#define PCI_CHIP_R430_554F		0x554F
#define PCI_CHIP_R423_5550		0x5550
#define PCI_CHIP_R423_UQ		0x5551
#define PCI_CHIP_R423_UR		0x5552
#define PCI_CHIP_R423_UT		0x5554
#define PCI_CHIP_RV410_564A		0x564A
#define PCI_CHIP_RV410_564B		0x564B
#define PCI_CHIP_RV410_564F		0x564F
#define PCI_CHIP_RV410_5652		0x5652
#define PCI_CHIP_RV410_5653		0x5653
#define PCI_CHIP_RS300_5834		0x5834
#define PCI_CHIP_RS300_5835		0x5835
#define PCI_CHIP_RS480_5954		0x5954
#define PCI_CHIP_RS480_5955		0x5955
#define PCI_CHIP_RV280_5960		0x5960
#define PCI_CHIP_RV280_5961		0x5961
#define PCI_CHIP_RV280_5962		0x5962
#define PCI_CHIP_RV280_5964		0x5964
#define PCI_CHIP_RV280_5965		0x5965
#define PCI_CHIP_RN50_5969		0x5969
#define PCI_CHIP_RS482_5974		0x5974
#define PCI_CHIP_RS482_5975		0x5975
#define PCI_CHIP_RS400_5A41		0x5A41
#define PCI_CHIP_RS400_5A42		0x5A42
#define PCI_CHIP_RC410_5A61		0x5A61
#define PCI_CHIP_RC410_5A62		0x5A62
#define PCI_CHIP_RV370_5B60		0x5B60
#define PCI_CHIP_RV370_5B62		0x5B62
#define PCI_CHIP_RV370_5B63		0x5B63
#define PCI_CHIP_RV370_5B64		0x5B64
#define PCI_CHIP_RV370_5B65		0x5B65
#define PCI_CHIP_RV370_5657		0x5657
#define PCI_CHIP_RV280_5C61		0x5C61
#define PCI_CHIP_RV280_5C63		0x5C63
#define PCI_CHIP_R430_5D48		0x5D48
#define PCI_CHIP_R430_5D49		0x5D49
#define PCI_CHIP_R430_5D4A		0x5D4A
#define PCI_CHIP_R480_5D4C		0x5D4C
#define PCI_CHIP_R480_5D4D		0x5D4D
#define PCI_CHIP_R480_5D4E		0x5D4E
#define PCI_CHIP_R480_5D4F		0x5D4F
#define PCI_CHIP_R480_5D50		0x5D50
#define PCI_CHIP_R480_5D52		0x5D52
#define PCI_CHIP_R423_5D57		0x5D57
#define PCI_CHIP_RV410_5E48		0x5E48
#define PCI_CHIP_RV410_5E4A		0x5E4A
#define PCI_CHIP_RV410_5E4B		0x5E4B
#define PCI_CHIP_RV410_5E4C		0x5E4C
#define PCI_CHIP_RV410_5E4D		0x5E4D
#define PCI_CHIP_RV410_5E4F		0x5E4F
#define PCI_CHIP_RS350_7834		0x7834
#define PCI_CHIP_RS350_7835		0x7835

enum {
   CHIP_FAMILY_R100,
   CHIP_FAMILY_RV100,
   CHIP_FAMILY_RS100,
   CHIP_FAMILY_RV200,
   CHIP_FAMILY_RS200,
   CHIP_FAMILY_R200,
   CHIP_FAMILY_RV250,
   CHIP_FAMILY_RS300,
   CHIP_FAMILY_RV280,
   CHIP_FAMILY_R300,
   CHIP_FAMILY_R350,
   CHIP_FAMILY_RV350,
   CHIP_FAMILY_RV380,
   CHIP_FAMILY_R420,
   CHIP_FAMILY_RV410,
   CHIP_FAMILY_RS400,
   CHIP_FAMILY_LAST
};

/* General classes of Radeons, as described above the device ID section */
#define RADEON_CLASS_R100		(0 << 0)
#define RADEON_CLASS_R200		(1 << 0)
#define RADEON_CLASS_R300		(2 << 0)
#define RADEON_CLASS_MASK		(3 << 0)

#define RADEON_CHIPSET_TCL		(1 << 2)	/* tcl support - any radeon */
#define RADEON_CHIPSET_BROKEN_STENCIL	(1 << 3)	/* r100 stencil bug */
#define R200_CHIPSET_YCBCR_BROKEN	(1 << 4)	/* r200 ycbcr bug */

#endif /* _RADEON_CHIPSET_H */
