/* mg-work-layout.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __MG_WORK_LAYOUT_H_
#define __MG_WORK_LAYOUT_H_

#include "mg-defs.h"
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define MG_WORK_LAYOUT_TYPE          (mg_work_layout_get_type())
#define MG_WORK_LAYOUT(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_work_layout_get_type(), MgWorkLayout)
#define MG_WORK_LAYOUT_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, mg_work_layout_get_type (), MgWorkLayoutClass)
#define IS_MG_WORK_LAYOUT(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_work_layout_get_type ())

typedef struct _MgWorkLayout        MgWorkLayout;
typedef struct _MgWorkLayoutClass   MgWorkLayoutClass;
typedef struct _MgWorkLayoutPrivate MgWorkLayoutPrivate;

/* error reporting */
extern GQuark mg_work_layout_error_quark (void);
#define MG_WORK_LAYOUT_ERROR mg_work_layout_error_quark ()

/* struct for the object's data */
struct _MgWorkLayout
{
	GtkVBox                 object;
	MgWorkLayoutPrivate    *priv;
};

/* struct for the object's class */
struct _MgWorkLayoutClass
{
	GtkVBoxClass          class;
};

guint           mg_work_layout_get_type                 (void);
GtkWidget      *mg_work_layout_new                      (MgCustomLayout *layout);
GtkWidget      *mg_work_layout_lookup_widget            (MgWorkLayout *layout, const gchar *widget_name);

G_END_DECLS

#endif
