/* mg-custom-layout.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __MG_CUSTOM_LAYOUT_H_
#define __MG_CUSTOM_LAYOUT_H_

#include <gtk/gtk.h>
#include "mg-base.h"
#include "mg-defs.h"
#include <libgda/libgda.h>
#include <glade/glade.h>
#include "mg-work-matrix.h"

G_BEGIN_DECLS

#define MG_CUSTOM_LAYOUT_TYPE          (mg_custom_layout_get_type())
#define MG_CUSTOM_LAYOUT(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_custom_layout_get_type(), MgCustomLayout)
#define MG_CUSTOM_LAYOUT_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, mg_custom_layout_get_type (), MgCustomLayoutClass)
#define IS_MG_CUSTOM_LAYOUT(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_custom_layout_get_type ())

typedef enum {
	MG_CUSTOM_LAYOUT_LAYOUT,
	MG_CUSTOM_LAYOUT_GRID,
	MG_CUSTOM_LAYOUT_FORM,
	MG_CUSTOM_LAYOUT_MATRIX
} MgCustomLayoutType;

typedef struct
{
	MgCustomLayoutType type;

	/* contents of the layout */
	union {
		/* sub layouts, for MG_CUSTOM_LAYOUT_LAYOUT */
		struct {
			GSList           *children; /* list of MgCustomLayout objects, DON'T FREE */
			GSList           *connects; /* list of MgCustomLayoutConnect structures, DON'T FREE */
		} layout;
		
		struct {
			/* for all the MgWork* widgets */
			MgQuery          *query;
			guint             mode;
			MgBase           *modified;

			/* For MgWorkMatrix only */
			MgQuery          *query_extra;
			MgTarget         *cols_target;
			MgTarget         *rows_target;
			MgWorkMatrixType  view_type;
		} work_iface;
	} contents;
} MgCustomLayoutData;

typedef struct {
	MgCustomLayout *src_layout;
	MgField        *src_field;
	MgCustomLayout *dest_layout;
	MgField        *dest_field;
} MgCustomLayoutConnect;

enum
{
	MG_CUSTOM_LAYOUT_XML_SAVE_ERROR,
	MG_CUSTOM_LAYOUT_XML_LOAD_ERROR,
	MG_CUSTOM_LAYOUT_GLADEXML_ERROR,
	MG_CUSTOM_LAYOUT_DATA_ERROR
};

/* error reporting */
extern GQuark mg_custom_layout_error_quark (void);
#define MG_CUSTOM_LAYOUT_ERROR mg_custom_layout_error_quark ()

/* struct for the object's data */
struct _MgCustomLayout
{
	MgBase                  object;
	MgCustomLayoutPrivate    *priv;
};

/* struct for the object's class */
struct _MgCustomLayoutClass
{
	MgBaseClass          class;
};

guint               mg_custom_layout_get_type                 (void);
GObject            *mg_custom_layout_new                      (MgConf *conf);
MgCustomLayoutType  mg_custom_layout_get_layout_type          (MgCustomLayout *layout);
MgCustomLayoutData *mg_custom_layout_get_data                 (MgCustomLayout *layout, GError **error);
void                mg_custom_layout_data_free                (MgCustomLayoutData *data);
GladeXML           *mg_custom_layout_get_glade_instance       (MgCustomLayout *layout, 
							       GtkWidget **root_widget, GHashTable **box_widgets, 
							       GError **error);
GtkWidget          *mg_custom_layout_get_widget               (MgCustomLayout *layout, GError **error);

MgContext          *mg_custom_layout_get_exec_context         (MgCustomLayout *layout);
MgContext          *mg_custom_layout_get_data_context         (MgCustomLayout *layout);

G_END_DECLS

#endif
