/* mg-canvas.h
 *
 * Copyright (C) 2002 - 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __MG_CANVAS__
#define __MG_CANVAS__

#include <gnome.h>
#include "mg-graph.h"
#include <libmergeant/mg-defs.h>

G_BEGIN_DECLS

#define MG_CANVAS_TYPE          (mg_canvas_get_type())
#define MG_CANVAS(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_canvas_get_type(), MgCanvas)
#define MG_CANVAS_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, mg_canvas_get_type (), MgCanvasClass)
#define IS_MG_CANVAS(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_canvas_get_type ())


/* struct for the object's data */
struct _MgCanvas
{
	GnomeCanvas         widget;

	/* pointer position when a context menu was last opened */
	gdouble             xmouse;
	gdouble             ymouse;
	/* private */
	MgCanvasPrivate    *priv;
};

/* struct for the object's class */
struct _MgCanvasClass
{
	GnomeCanvasClass parent_class;

	/* virtual functions */
	void           (*create_canvas_items) (MgCanvas *canvas); /* create individual MgCanvasItem objects */
	void           (*clean_canvas_items)  (MgCanvas *canvas); /* clean any extra structure, not the individual items */

	void           (*graph_item_added)    (MgCanvas *canvas, MgGraphItem *item);
	void           (*graph_item_dropped)  (MgCanvas *canvas, MgGraphItem *item);

	GtkWidget     *(*build_context_menu)  (MgCanvas *canvas);
	void           (*set_pixels_per_unit) (MgCanvas *canvas, gdouble n);

	/* signals */
	void           (*drag_action)        (MgCanvas *canvas, MgCanvasItem *from_item, MgCanvasItem *to_item);
};

/* generic widget's functions */
guint            mg_canvas_get_type                (void);

MgGraph         *mg_canvas_get_graph               (MgCanvas *canvas);

GtkWidget       *mg_canvas_set_in_scrolled_window  (MgCanvas *canvas);
void             mg_canvas_declare_item            (MgCanvas *canvas, MgCanvasItem *item);

MgCanvasItem    *mg_canvas_get_item_for_object     (MgCanvas *canvas, MgBase *ref_obj);
void             mg_canvas_set_zoom_factor         (MgCanvas *canvas, gdouble n);
gdouble          mg_canvas_get_zoom_factor         (MgCanvas *canvas);
gdouble          mg_canvas_fit_zoom_factor         (MgCanvas *canvas);

#define MG_CANVAS_ENTITY_COLOR      "yellow"
#define MG_CANVAS_DB_TABLE_COLOR    "lightblue"
#define MG_CANVAS_QUERY_COLOR       "lightgreen"

G_END_DECLS

#endif
