#!/bin/sh

set -e

#first, get rid of the output update-menu handed to us
# (this is now new-syntax menu information)
cat > /dev/null


cat <<"EOF"
Hi there!

You are guilty of possessing a system with (at least) one /etc/menu-methods/*
that is written using the over 2-years-old menu-method syntax.

The program used for interpreting this old syntax started segfaulting
in menu version 1.5-20, causing many problems.

I've been maintaining the compat stuff now for over two years, and I
simply don't feel like it's worth the trouble any more.

So, in this menu version, support for the 2-years-old menu-method syntax
has been removed.


What should you do now?

EOF

BASE=`basename $1`
EXAMP=/usr/doc/menu/examples/$BASE
METHOD=/etc/menu-methods/$BASE
if test -f $EXAMP; then
cat <<EOF
Well, you are lucky as I (menu maintainer) have already re-written
the old-syntax $METHOD file, and put the new-syntax version
in /usr/doc/menu/examples/$BASE. So, if you are a sysadmin, simply do:
  cp $EXAMP $METHOD
If you are the maintain'er of $BASE, then please replace $METHOD 
with the new $EXAMP file in your package.

Thanks!
joostje@debian.org
EOF

else
cat <<EOF
Well, although I did try to rewrite as many (all?) menu-methods files
in /etc/menu-methods/, I seem to have overlooked $BASE. So, it needs
to be written. It isn't all that difficult, so probably you will succeed
in doing it yourself, by looking at the documentation in /usr/doc/menu,
and other example menu-method files in /etc/menu-methods/.
However, I would very much like to help with this, so if you don't have
the inclination, time, or have any other problem, just send the latest
version of your menu-method file to me, and I will translate it.

Thanks!
joostje@debian.org
EOF
fi

