#ifndef MENU_TREE_H
#define MENU_TREE_H


#include <map>
#include <vector>
#include <deque>
#include "adstring.h"
#include "install-menu.h"

class menuentry;

bool operator< (const StrVec &left, const StrVec &right);

/*in submenu_container:
  StrVec    first   - full title, broken into a StrVec
  menuentry *second - the menu entry with this title
*/
typedef map <StrVec, menuentry *, less<StrVec> > submenu_container;

class menuentry {
private:
  char hotkeyconv(char);
  void generate_hotkeys();
  void store_hints();
  StrVec section; //Do we need section? I think not. (is in parent's submenus)
  StrVec menuhints;

public:
  submenu_container submenus;
  map <String, String, less<String> > vars;
  bool forced;

  void add_entry(StrVec, map <String, String, less<String> > &);
  void add_menuentry_ptr(StrVec s, menuentry *m);
  void output();
  void postprocess(int n_parent, int level, String title);
  void process_hints(const StrVec &pref);
  void debug(int);
  menuentry(){
    forced=false;
  }
};


#endif /* MENU_TREE_H */
