/* melon.h -- main header file 
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 * This code is released under the GPL License version 2 */

#include <errno.h>
#include <sys/types.h>
#include "def.h"

#ifndef MELON_H
#define MELON_H
#define MAX_MBOX	50

#define MELON_VERSION	"1.4"

/* data types and structures */
struct widgets_data {
	GtkWidget	*window;
	GtkWidget	*pixmap;
	GdkPixmap	*gdk_pixmap;
	GdkPixmap	*new_gdk_pixmap;
	GdkBitmap	*mask1;
	GdkBitmap	*mask2;
	int		unread_msg[MAX_MBOX];
	time_t		m_time[MAX_MBOX];
	off_t		size[MAX_MBOX];
	int		beep[MAX_MBOX];
};

struct pixmaps_data {
	char pix_name[MAX_PLEN];
	char no_mail_pix[MAX_PLEN];
	char new_mail_pix[MAX_PLEN];
};

struct config_data {
	char no_mail_pix[MAX_PLEN];
	char new_mail_pix[MAX_PLEN];
	char beep_file[MAX_PLEN];
	char beep_device[MAX_PLEN];
	int beep_mode;
	int interval;
	char xposition[16];
	char yposition[16];
	int save_status;
	char mbox[MAX_MBOX][MAX_PLEN];
	int is_a_mbox[MAX_MBOX];
	char mailer[MAX_PLEN];
	char color_style[16];
	GdkColor bgcolor;
	GdkColor fgcolor;
	GdkColor abgcolor;
	GdkColor afgcolor;
};

#include "globals.h"

/* function prototypes */
int melon_error(const char *fmt, ...);
gint check_mbox (gpointer data);
void config_update (void);
gint see_mail (GtkWidget *widget, char *mbox);
void play_beep(void);
void pop_menu(GdkEventButton *event_button);
void active_mbox_menu(GdkEventButton *event_button);
int none_active_mbox(void);
int pixmap_exist (char *path);
void dialog_message (char *message);
void reset_mbox_status (char *mbox);
void set_style(void);
void set_melon_def_colors (void);
gint close_application( GtkWidget *widget,
	GdkEvent  *event,
	gpointer   data );

#endif
