%
% Call all of the functions in the "simple.h" file.
%
% I use print_str instead of disp because octave mixes up the order of
% the output when you use disp and also cout directly.  print_str() is
% not recommended as a replacement for disp().
%
print_str('The following should output pi:');
print_num(pi);

print_str('The following should output a random vector:');
print_vec(rand(3,1));

print_str('The following should output a random matrix:');
print_mat(rand(3));

print_str('The following should say Hello, world:');
print_cmat('Hello, world');

print_str('The following should display the same string in opposite case.');
print_str('Although the function takes a single character, input, a');
print_str('character array is returned because the function is vectorized.');
print_str(flip_case('Hello, world'));

print_str('Call the real strcmp function: compare abc and def.')
print_num(real_strcmp('abc', 'def'));

print_str('Calling get_str():');
print_str(get_str(0));

print_str('Calling set/get_some_global_var:');
set_some_global_var(31);
print_num(get_some_global_var);

print_str('Calling abc_set/get_ghi');
abc_set_ghi(3);
print_num(abc_get_ghi);

print_str('Creating new abc structure and setting its data member jkl to 47');
abc = abc_new;
abc_set_jkl(abc, 47);
print_num(abc_get_jkl(abc));

print_str('Calling abc::jkl_plus(3)');
print_num(abc_jkl_plus(abc, 3));

abc_delete(abc);		% Get rid of the structure.
