// -*- c++ -*-
#ifndef INCLUDED_MATH3D_MLOOKAT_H
#define INCLUDED_MATH3D_MLOOKAT_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mlookat.h,v 1.3 2000/10/09 12:17:54 jeh Exp $
 */

#ifndef INCLUDED_MATH3D_M3FRAME_H
#include <math3d/m3frame.h>
#endif

namespace Math3d {
  
/**
 * Frenet 3-frame + target.
 */
  class _CCMATH3D MLookAt : public M3Frame {
    protected:  
      double d_dist;
    public:
      MLookAt();
      MLookAt(const M3d& pos, const M3d& right, const M3d& dir, 
        const M3d& up, double dist);
      MLookAt(const MLookAt& la);
      virtual ~MLookAt();
      
      const MLookAt& operator=(const MLookAt& la);
      const MLookAt& operator=(const M3Frame& fr);
      void copy(const MLookAt& fr);

      void setDist(double dist);
      void azimuth(double angle);
      void elevation(double);
      void dolly(double dist);

      double getDist() const;
      M3d getTgt() const;
      
      bool operator==(const MLookAt& fr) const;
      bool operator!=(const MLookAt& fr) const;
      bool cmp(const MLookAt& fr, double epsilon=EPSILON) const;
  };

}
#endif // INCLUDED_MATH3D_MLOOKAT_H 







