// -*- c++ -*-
#ifndef INCLUDED_MATH3D_MATH3DDEF_H
#define INCLUDED_MATH3D_MATH3DDEF_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: math3ddef.h,v 1.4 2000/10/09 12:17:54 jeh Exp $
 */

#ifdef _NODLLCC
#define _CCMATH3D
#else 
#ifdef _WIN32
#ifdef _MATH3D_EXPORT
#define _CCMATH3D __declspec(dllexport)
#else               
#define _CCMATH3D __declspec(dllimport)
#endif
#else
#define _CCMATH3D
#endif
#endif

#ifndef PI
#define PI 3.14159265358979323846
#endif
#ifndef TWOPI
#define TWOPI (2.0*PI)
#endif
#ifndef HALFPI
#define HALFPI (PI/2.0)
#endif
#define EPSILON 1e-10
#define CMP_EPSILON 1e-10
#define DEG(x) ((180.0/PI)*(x))
#define RAD(x) ((PI/180.0)*(x))

#include <stddef.h>
#include <assert.h>
#include <iostream>

using std::ostream;

#ifndef ASSERT
#define ASSERT(x) assert(x)
#endif
#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif

#endif // INCLUDED_MATH3D_MATH3DDEF_H
