/*
                   Manual Page Editor: Configuration
 */

#ifndef CONFIG_H
#define CONFIG_H

#ifndef PREFIX
# define PREFIX	"/usr"
#endif


/*
 *      Languages (define only one):
 */
#define PROG_LANGUAGE_ENGLISH   1
/* #define PROG_LANGUAGE_SPANISH        2 */
/* #define PROG_LANGUAGE_FRENCH         3 */
/* incomplete #define PROG_LANGUAGE_GERMAN      4 */
/* incomplete #define PROG_LANGUAGE_ITALIAN     5 */
/* incomplete #define PROG_LANGUAGE_NORWEGIAN   6 */
/* incomplete #define PROG_LANGUAGE_PORTUGUESE  7 */


/*
 *	Program Name & Version:
 */
#define PROG_NAME		"ManEdit"
#define PROG_NAME_FULL		"ManEdit"
#define PROG_VERSION		"0.7.1"

#define PROG_VERSION_MAJOR	0
#define PROG_VERSION_MINOR	7
#define PROG_VERSION_RELEASE	1

/*
 *	Program Copyright:
 */
#define PROG_COPYRIGHT	"\
Copyright (C) 2000-2006 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law."

/*
 *	Program usage message:
 */
#define PROG_USAGE_MESG	"\
Usage: manedit [manual_page] [options] [GUI_options]\n\
\n\
    The [manual_page] specifies the path to the manual page file\n\
    to open at startup.\n\
\n\
    The [options] can be any of the following:\n\
\n\
        --config <file>         Load configuration from <file>.\n\
        --rcfile                Same as --config.\n\
        -f                      Same as --config.\n\
        --viewer                Start up with a viewer instead of an\n\
                                editor.\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    Most customizations can be performed in the options menu.\n\
\n\
    Command line options override any options in the configuration file.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult your\n\
    GUI's manual for available options.\n\
\n"


/*
 *	Default editor size in pixels:
 */
#define MEDIT_DEF_WIDTH		800
#define MEDIT_DEF_HEIGHT	600

/*
 *	Default viewer size in pixels.
 */
#define MEDIT_VIEWER_DEF_WIDTH	640
#define MEDIT_VIEWER_DEF_HEIGHT	512

/*
 *	Default Preferences & Options window size in pixels:
 */
#define MEDIT_PREF_DEF_WIDTH	640
#define MEDIT_PREF_DEF_HEIGHT	480

/*
 *	Default paned widget size in pixels:
 */
#define MEDIT_DEF_PANED_GUTTER_SIZE	12
#define MEDIT_DEF_PANED_HANDLE_SIZE	10

/*
 *	Spacing between list item icons and text in pixels:
 */
#define MEDIT_LIST_ICON_TEXT_SPACING	2


/*
 *	Viewer window title:
 */
#define MEDIT_VIEWER_TITLE	"Manual Page Viewer"

/*
 *	Preferences & Options window title:
 */
#define MEDIT_PREF_TITLE	"Manual Page Editor: Preferences"


/*
 *	Syntax highlighting enabled by default (TRUE or FALSE)?
 */
#define MEDIT_DEF_SYNTAX_HIGHLIGHTING	FALSE

/*
 *	ManEdit local configuration file:
 *
 *	User's home directory will be prepended.
 */
#define MEDIT_RCFILE_LOCAL	".maneditrc"


/*
 *	ManEdit global directory:
 */
#define MEDIT_GLOBAL_DIR	(PREFIX "/share/manedit")

/*
 *	Manual page help sub directory (MEDIT_GLOBAL_DIR will
 *      be prepended at run time):
 */
#define MEDIT_HELP_DIR		"help"

/*
 *	Manual page templates sub directory (MEDIT_GLOBAL_DIR will
 *	be prepended at run time):
 */
#define MEDIT_TEMPLATES_DIR	"templates"


/*
 *	Help files, located in MEDIT_GLOBAL_DIR/MEDIT_HELP_DIR:
 */
#define MEDIT_MANPAGE_WRITING_FILE		"manpage_writing_procedures"
#define MEDIT_MANPAGE_XML_REFERENCE_FILE	"manpage_xml_reference"


/*
 *	Fond specification format strings:
 */
#define MEDIT_FONT_NAME_HEADING1	\
	"-adobe-helvetica-medium-r-normal-*-24-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING2	\
	"-adobe-helvetica-medium-r-normal-*-20-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING3	\
	"-adobe-helvetica-medium-r-normal-*-18-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING4	\
	"-adobe-helvetica-medium-r-normal-*-16-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING5	\
	"-adobe-helvetica-medium-r-normal-*-14-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING6	\
	"-adobe-helvetica-medium-r-normal-*-12-*-*-*-p-*-iso8859-1"

#define MEDIT_FONT_NAME_HEADING1_REV	\
	"-adobe-helvetica-medium-r-normal-*-24-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING2_REV	\
        "-adobe-helvetica-medium-r-normal-*-20-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING3_REV	\
        "-adobe-helvetica-medium-r-normal-*-18-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING4_REV	\
	"-adobe-helvetica-medium-r-normal-*-16-*-*-*-p-*-iso8859-1"

#define MEDIT_FONT_NAME_EDIT_STD	\
	"-adobe-courier-medium-r-*-*-14-*-*-*-*-*-*-*"

#define MEDIT_FONT_NAME_MANPAGE_STD	\
        "-adobe-courier-medium-r-*-*-14-*-*-*-*-*-*-*"
#define MEDIT_FONT_NAME_MANPAGE_BOLD	\
	"-adobe-courier-medium-r-*-*-14-*-*-*-*-*-*-*"
#define MEDIT_FONT_NAME_MANPAGE_UNDERLINE	\
        "-adobe-courier-medium-r-*-*-14-*-*-*-*-*-*-*"


/*
 *	Clist and ctree row spacing (in pixels):
 */
#define MEDIT_LIST_ROW_SPACING	20

/*
 *	Color strings:
 */
#define MEDIT_CSTR_EDIT_TEXT_FG		"black"
#define MEDIT_CSTR_EDIT_TEXT_BG		"white"
#define MEDIT_CSTR_EDIT_TEXT_DELIM_FG	"#a000a0"
#define MEDIT_CSTR_EDIT_TEXT_TAG_FG	"#0040a0"
#define MEDIT_CSTR_EDIT_TEXT_SYMREP_FG	"#a04000"

#define MEDIT_CSTR_MANPAGE_TEXT_FG		"black"
#define MEDIT_CSTR_MANPAGE_TEXT_BG		"#ffffc0"
#define MEDIT_CSTR_MANPAGE_TEXT_BOLD_FG		"black"
#define MEDIT_CSTR_MANPAGE_TEXT_UNDERLINE_FG	"black"


/*
 *      Drag and drop target type names and info values:
 */
#define MEDIT_DND_TYPE_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define MEDIT_DND_TYPE_INFO_TEXT_URI_LIST	1	/* "text/uri-list" */
#define MEDIT_DND_TYPE_INFO_STRING		2	/* "STRING" */

#define MEDIT_DND_TYPE_INFO_EDITOR_BRANCH_CMD	3
#define MEDIT_DND_TYPE_NAME_EDITOR_BRANCH_CMD	"manedit/editor/branch"
#define MEDIT_DND_TYPE_INFO_VIEWER_BRANCH_CMD	4
#define MEDIT_DND_TYPE_NAME_VIEWER_BRANCH_CMD	"manedit/viewer/branch"


/*
 *	Convert manual page to printable output command:
 *
 *	%f = filename
 *	%p = optional parameters
 */
#if !defined(__FreeBSD__)
#define MEDIT_CMD_MANPAGE_TO_OUTPUT	(PREFIX "/bin/man %p %f")
#else
#define MEDIT_CMD_MANPAGE_TO_OUTPUT	(PREFIX "/bin/manwrap %p %f")
#endif	/* !__FreeBSD__ */

/*
 *	List of names for sections by number:
 */
#define MEDIT_SECT_NAME_ANY	"*Any*"		/* Any section. */
#define MEDIT_SECT_NAME_EXACT	"*Exact*"	/* Full path to manpage file. */

#define MEDIT_SECT_NAME_1	"User Commands"
#define MEDIT_SECT_NAME_2	"System Calls"
#define MEDIT_SECT_NAME_3	"Library Functions"
#define MEDIT_SECT_NAME_4	"Special Files"
#define MEDIT_SECT_NAME_5	"File Formats"
#define MEDIT_SECT_NAME_6	"Games"
#define MEDIT_SECT_NAME_7	"Miscellaneous"
#define MEDIT_SECT_NAME_8	"Administration"


#endif	/* CONFIG_H */
