/*
                Manual Page Editor: Operations and Procedures
 */

#ifndef EDITOROP_H
#define EDITOROP_H

#include <gtk/gtk.h>
#include "editor.h"


extern void EditorSyntaxHighlight(
        editor_struct *editor, GtkWidget *w,
        int cursor_pos, int start_pos, int end_pos
);

extern void EditorDoFetchValues(
	editor_struct *editor, GtkCTreeNode *branch
);
extern void EditorDoApplyValues(
	editor_struct *editor, GtkCTreeNode *branch
);
extern void EditorDoClearValues(editor_struct *editor);

extern void EditorDoPreview(
        editor_struct *editor, GtkCTreeNode *branch,
        int viewer_num
);

extern gbool EditorDoFind(
        editor_struct *editor, GtkText *text,
        char *haystack, char *needle,
        int haystack_len, int start_pos,
        gbool case_sensitive,
	gbool move_to,
        gbool *search_wrapped
);
extern gbool EditorDoReplace(
        editor_struct *editor, GtkText *text,
        char *haystack, char *needle, const char *replacement,
        int haystack_len, int start_pos,
        gbool case_sensitive
);
extern int EditorDoReplaceAll(
        editor_struct *editor, GtkText *text,
        char *needle, const char *replacement,
        gbool case_sensitive
);

#endif	/* EDITOROP_H */
