/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file ValuePlot.cc
    \brief Implementation of the Template class ValuePlot.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 3-Mar-2004
    
    Changes:
    
*/

#include "ValuePlot.h"
#include "Symbol.h"
#include "MarkerValuePlotMethod.h"
#include "BothValuePlotMethod.h"

using namespace magics;

template <class P>
ValuePlot<P>::ValuePlot() 
{
   
}

template <class P>
ValuePlot<P>::~ValuePlot() 
{
}



/*!
 Class information are given to the output-stream.
*/	
template <class P>	
void ValuePlot<P>::print(ostream& out)  const
{
	out << "ValuePlot<P>[";
	ValuePlotAttributes<P>::print(out);
	out << "]";
}

template <class P>	
void ValuePlot<P>::operator()(MatrixHandler<P>& data, BasicGraphicsObjectContainer& parent)
{
	(*(this->method_)).clear();
    (*(this->method_))(data, parent.transformation());
    
    // Now we feed the task
    for ( vector<BasicGraphicsObject*>::const_iterator object = (*this->method_).begin(); object != (*this->method_).end(); ++object)
    	parent.push_back(*object);
}
template <class P>	
void ValuePlot<P>::operator()(Data<P>& data, BasicGraphicsObjectContainer& parent)
{
	(*(this->method_)).clear();
    (*(this->method_))(data.points(parent.transformation()), parent.transformation());
    
    // Now we feed the task
    for ( vector<BasicGraphicsObject*>::const_iterator object = (*this->method_).begin(); object != (*this->method_).end(); ++object)
    	parent.push_back(*object);
}
template <class P>	
void ValuePlot<P>::visit(LegendVisitor&)
{
}
    
static SimpleObjectMaker<ValuePlotMethod<GeoPoint> > value_plot_method("value");
static SimpleObjectMaker<BothValuePlotMethod<GeoPoint>, ValuePlotMethod<GeoPoint> > both_value_plot_method("both");
static SimpleObjectMaker<MarkerValuePlotMethod<GeoPoint>, ValuePlotMethod<GeoPoint> > marker_value_plot_method("marker");
