/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file PolyShadingTechniqueAttributes.cc
    \brief Implemtation of PolyShadingTechnique Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:43 2012
*/    

#include "PolyShadingTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;

template <class P>
PolyShadingTechniqueAttributes<P>::PolyShadingTechniqueAttributes()
{

	MagTranslator<string, PolyShadingMethod<P> > method;
	setMethod(method.magics("contour_shade_method"));
} 


template <class P>
PolyShadingTechniqueAttributes<P>::~PolyShadingTechniqueAttributes()
{
}

template <class P>    
void PolyShadingTechniqueAttributes<P>::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	prefix[0] = "contour_shade";
	prefix[1] = "contour_shade";
	prefix[2] = "contour_shade";
	prefix[3] = "contour";
	prefix[4] = "contour";

	setMember(prefix, "contour_shade_method", method_, params);
}
template <class P>
void PolyShadingTechniqueAttributes<P>::copy(const PolyShadingTechniqueAttributes& other)
{
	setMethod(other.method_->clone());
} 

template <class P>
bool PolyShadingTechniqueAttributes<P>::accept(const string& node)
{	
	if ( magCompare(node, "polygon")  )
		return true;

	if ( acceptNode(node, method_) )
		return true;
	return false;
}
template <class P>
void PolyShadingTechniqueAttributes<P>::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "polygon") )
		set(node.attributes());
	else {
		setMember(node.name(), method_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), method_, *(*elt)); 
	}
}
template <class P>
void PolyShadingTechniqueAttributes<P>::print(ostream& out)  const
{
	out << "PolyShadingTechniqueAttributes[";
	out << "method = " << *method_;
	out << "]" << "\n";
}

template <class P>
void PolyShadingTechniqueAttributes<P>::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"polygon\"";
	 out << ", \"contour_shade_method\":";
	 method_->toxml(out, 0);
}
static MagicsParameter<string> contour_shade_method("contour_shade_method", "dot", "");
#include "HatchPolyShadingMethod.h"
#include "UserPoint.h"
#include "GeoPoint.h"
#include "DotPolyShadingMethod.h"
#include "PolyShadingMethod.h"
static SimpleObjectMaker<PolyShadingMethod<GeoPoint>, PolyShadingMethod<GeoPoint> > area_fill_PolyShadingMethod_GeoPoint("area_fill");
static SimpleObjectMaker<PolyShadingMethod<UserPoint>, PolyShadingMethod<UserPoint> > area_fill_PolyShadingMethod_UserPoint("area_fill");
static SimpleObjectMaker<DotPolyShadingMethod<GeoPoint>, PolyShadingMethod<GeoPoint> > dot_DotPolyShadingMethod_GeoPoint("dot");
static SimpleObjectMaker<DotPolyShadingMethod<UserPoint>, PolyShadingMethod<UserPoint> > dot_DotPolyShadingMethod_UserPoint("dot");
static SimpleObjectMaker<HatchPolyShadingMethod<GeoPoint>, PolyShadingMethod<GeoPoint> > hatch_HatchPolyShadingMethod_GeoPoint("hatch");
static SimpleObjectMaker<HatchPolyShadingMethod<UserPoint>, PolyShadingMethod<UserPoint> > hatch_HatchPolyShadingMethod_UserPoint("hatch");
