/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HistogramLegendMethodAttributes.h
    \brief Definition of HistogramLegendMethod Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:46 2012
*/
   

#ifndef HistogramLegendMethodAttributes_H
#define HistogramLegendMethodAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class HistogramLegendMethodAttributes 
{
public:
//  --  constructor
    HistogramLegendMethodAttributes();
    
//  --  destructor
    virtual ~HistogramLegendMethodAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const HistogramLegendMethodAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Frequency of the labels. 
    \param label_frequency Setting legend_label_frequency - default=1
*/
	void setLabel_frequency(int label_frequency) 
		{ label_frequency_ =  label_frequency; } 
	int getLabel_frequency() const 
		{ return label_frequency_; } 
        
/*!
    Magics Information:
    \brief  add a border to the the bars 
    \param histo_border Setting legend_histogram_border - default=on
*/
	void setHisto_border(bool histo_border) 
		{ histo_border_ =  histo_border; } 
	bool getHisto_border() const 
		{ return histo_border_; } 
        
/*!
    Magics Information:
    \brief  border colour of the bars
    \param histo_border_colour Setting legend_histogram_border_colour - default=black
*/
	void setHisto_border_colour(Colour* histo_border_colour) 
		{ auto_ptr<Colour> tmp(histo_border_colour); histo_border_colour_ = tmp; } 
	const Colour&  getHisto_border_colour() const 
		{ return *histo_border_colour_; }
/*!
    Magics Information:
    \brief  show the mean value 
    \param histo_mean Setting legend_histogram_mean_value - default=off
*/
	void setHisto_mean(bool histo_mean) 
		{ histo_mean_ =  histo_mean; } 
	bool getHisto_mean() const 
		{ return histo_mean_; } 
        
/*!
    Magics Information:
    \brief  show the mean value 
    \param histo_mean_marker Setting legend_histogram_mean_value_marker - default=15
*/
	void setHisto_mean_marker(int histo_mean_marker) 
		{ histo_mean_marker_ =  histo_mean_marker; } 
	int getHisto_mean_marker() const 
		{ return histo_mean_marker_; } 
        
/*!
    Magics Information:
    \brief  show the mean value 
    \param histo_mean_colour Setting legend_histogram_mean_value_marker_colour - default=black
*/
	void setHisto_mean_colour(Colour* histo_mean_colour) 
		{ auto_ptr<Colour> tmp(histo_mean_colour); histo_mean_colour_ = tmp; } 
	const Colour&  getHisto_mean_colour() const 
		{ return *histo_mean_colour_; }
/*!
    Magics Information:
    \brief  show the mean value 
    \param histo_mean_size Setting legend_histogram_mean_value_marker_size - default=0.4
*/
	void setHisto_mean_size(double histo_mean_size) 
		{ histo_mean_size_ =  histo_mean_size; } 
	double getHisto_mean_size() const 
		{ return histo_mean_size_; } 
        
/*!
    Magics Information:
    \brief  show the max value 
    \param histo_max Setting legend_histogram_max_value - default=on
*/
	void setHisto_max(bool histo_max) 
		{ histo_max_ =  histo_max; } 
	bool getHisto_max() const 
		{ return histo_max_; } 
        
/*!
    Magics Information:
    \brief  Colour of the grids 
    \param histo_grid_colour Setting legend_histogram_grid_colour - default=black
*/
	void setHisto_grid_colour(Colour* histo_grid_colour) 
		{ auto_ptr<Colour> tmp(histo_grid_colour); histo_grid_colour_ = tmp; } 
	const Colour&  getHisto_grid_colour() const 
		{ return *histo_grid_colour_; }
/*!
    Magics Information:
    \brief   Line Style of the grids 
    \param histo_grid_style Setting legend_histogram_grid_line_style - default=solid
*/
	void setHisto_grid_style(LineStyle histo_grid_style) 
		{ histo_grid_style_ =  histo_grid_style; } 
	LineStyle getHisto_grid_style() const 
		{ return histo_grid_style_; } 
        
/*!
    Magics Information:
    \brief   thickness of the grids 
    \param histo_grid_thickness Setting legend_histogram_grid_thickness - default=1
*/
	void setHisto_grid_thickness(int histo_grid_thickness) 
		{ histo_grid_thickness_ =  histo_grid_thickness; } 
	int getHisto_grid_thickness() const 
		{ return histo_grid_thickness_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	int label_frequency_;
	bool histo_border_;
	auto_ptr<Colour> histo_border_colour_;
	bool histo_mean_;
	int histo_mean_marker_;
	auto_ptr<Colour> histo_mean_colour_;
	double histo_mean_size_;
	bool histo_max_;
	auto_ptr<Colour> histo_grid_colour_;
	LineStyle histo_grid_style_;
	int histo_grid_thickness_;

private:
  
	friend ostream& operator<<(ostream& s,const HistogramLegendMethodAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
