/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisTickLabelAttributes.cc
    \brief Implemtation of AxisTickLabel Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:46 2012
*/    

#include "AxisTickLabelAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisTickLabelAttributes::AxisTickLabelAttributes():
	colour_(MagTranslator<string, Colour>().magics("axis_tick_label_colour")),
	first_(MagTranslator<string, bool>().magics("axis_tick_label_first")),
	frequency_(ParameterManager::getInt("axis_tick_label_frequency")),
	height_(ParameterManager::getDouble("axis_tick_label_height")),
	last_(MagTranslator<string, bool>().magics("axis_tick_label_last")),
	orientation_(ParameterManager::getString("axis_tick_label_orientation")),
	position_(ParameterManager::getString("axis_tick_label_position")),
	font_(ParameterManager::getString("axis_tick_label_font")),
	font_style_(ParameterManager::getString("axis_tick_label_font_style")),
	type_(MagTranslator<string, AxisTickLabelType>().magics("axis_tick_label_type"))
{
} 



AxisTickLabelAttributes::~AxisTickLabelAttributes()
{
}

    
void AxisTickLabelAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_tick_label";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_tick_label_colour", colour_, params);
	setAttribute(prefix, "axis_tick_label_first", first_, params);
	setAttribute(prefix, "axis_tick_label_frequency", frequency_, params);
	setAttribute(prefix, "axis_tick_label_height", height_, params);
	setAttribute(prefix, "axis_tick_label_last", last_, params);
	setAttribute(prefix, "axis_tick_label_orientation", orientation_, params);
	setAttribute(prefix, "axis_tick_label_position", position_, params);
	setAttribute(prefix, "axis_tick_label_font", font_, params);
	setAttribute(prefix, "axis_tick_label_font_style", font_style_, params);
	setMember(prefix, "axis_tick_label_type", type_, params);
}

void AxisTickLabelAttributes::copy(const AxisTickLabelAttributes& other)
{
	setColour(other.colour_->clone());
	first_ = other.first_;
	frequency_ = other.frequency_;
	height_ = other.height_;
	last_ = other.last_;
	orientation_ = other.orientation_;
	position_ = other.position_;
	font_ = other.font_;
	font_style_ = other.font_style_;
	setType(other.type_->clone());
} 


bool AxisTickLabelAttributes::accept(const string& node)
{	
	if ( magCompare(node, "label")  )
		return true;

	if ( acceptNode(node, type_) )
		return true;
	return false;
}

void AxisTickLabelAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "label") )
		set(node.attributes());
	else {
		setMember(node.name(), type_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), type_, *(*elt)); 
	}
}

void AxisTickLabelAttributes::print(ostream& out)  const
{
	out << "AxisTickLabelAttributes[";
	out << "colour = " << *colour_;
	out << ", first = " << first_;
	out << ", frequency = " << frequency_;
	out << ", height = " << height_;
	out << ", last = " << last_;
	out << ", orientation = " << orientation_;
	out << ", position = " << position_;
	out << ", font = " << font_;
	out << ", font_style = " << font_style_;
	out << ", type = " << *type_;
	out << "]" << "\n";
}


void AxisTickLabelAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"label\"";
	 out << ", \"axis_tick_label_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"axis_tick_label_first\":";
	 niceprint(out,first_);
	 out << ", \"axis_tick_label_frequency\":";
	 niceprint(out,frequency_);
	 out << ", \"axis_tick_label_height\":";
	 niceprint(out,height_);
	 out << ", \"axis_tick_label_last\":";
	 niceprint(out,last_);
	 out << ", \"axis_tick_label_orientation\":";
	 niceprint(out,orientation_);
	 out << ", \"axis_tick_label_position\":";
	 niceprint(out,position_);
	 out << ", \"axis_tick_label_font\":";
	 niceprint(out,font_);
	 out << ", \"axis_tick_label_font_style\":";
	 niceprint(out,font_style_);
	 out << ", \"axis_tick_label_type\":";
	 type_->toxml(out, 0);
}
static MagicsParameter<string> axis_tick_label_colour("axis_tick_label_colour", "automatic", "");
static MagicsParameter<string> axis_tick_label_first("axis_tick_label_first", "on", "");
static MagicsParameter<int> axis_tick_label_frequency("axis_tick_label_frequency", 1, "");
static MagicsParameter<double> axis_tick_label_height("axis_tick_label_height", 0.3, "");
static MagicsParameter<string> axis_tick_label_last("axis_tick_label_last", "on", "");
static MagicsParameter<string> axis_tick_label_orientation("axis_tick_label_orientation", "horizontal", "");
static MagicsParameter<string> axis_tick_label_position("axis_tick_label_position", "on_tick", "");
static MagicsParameter<string> axis_tick_label_font("axis_tick_label_font", "sansserif", "");
static MagicsParameter<string> axis_tick_label_font_style("axis_tick_label_font_style", "", "");
static MagicsParameter<string> axis_tick_label_type("axis_tick_label_type", "number", "");
#include "AxisTickLabelType.h"
static SimpleObjectMaker<NumberLabelType, AxisTickLabelType> number_NumberLabelType("number");
static SimpleObjectMaker<LabelListLabelType, AxisTickLabelType> label_list_LabelListLabelType("label_list");
static SimpleObjectMaker<LabelListLabelType, AxisTickLabelType> list_LabelListLabelType("list");
