/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file TextOrientation.h
    \brief Definition of the Template class TextOrientation.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 7-Oct-2005
    
    Changes:
    
*/

#ifndef TextOrientation_H
#define TextOrientation_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"



namespace magics {

class TextOrientation {

public:
	TextOrientation();
	virtual ~TextOrientation();
    
    virtual void set(const XmlNode&) {
        Log::dev() << "(const XmlNode&)---> to be checked!...\n";
    }
    virtual void set(const map<string, string>&) {
        Log::dev() << "(const map<string, string&)---> to be checked!...\n";
    }
    virtual TextOrientation* clone() const {
        Log::dev() << "(const map<string, string&)---> to be checked!...\n";
        return new TextOrientation();
    }
     virtual void toxml(ostream&, int)  const {}
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	TextOrientation(const TextOrientation&);
    //! Overloaded << operator to copy - No copy allowed
	TextOrientation& operator=(const TextOrientation&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const TextOrientation& p)
		{ p.print(s); return s; }

};

template <>
class Translator<string, TextOrientation> { 
public:
	TextOrientation* operator()(const string& val )
	{
		return SimpleObjectMaker<TextOrientation>::create(val);
	}     

	TextOrientation* magics(const string& param)
	{
		string val;
		ParameterManager::get(param, val);
		return (*this)(val);
	}
};

} // namespace magics
#endif
