/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file MetgramFlagsAttributes.cc
    \brief Implemtation of MetgramFlags Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed May  5 10:05:13 2010
*/    

#include "MetgramFlagsAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


MetgramFlagsAttributes::MetgramFlagsAttributes():
	colour_(Translator<string, Colour>().magics("metgram_flag_colour")),
	frequency_(ParameterManager::getInt("metgram_flag_frequency")),
	length_(ParameterManager::getDouble("metgram_flag_length"))
{
} 



MetgramFlagsAttributes::~MetgramFlagsAttributes()
{
}

    
void MetgramFlagsAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "metgram";

	setAttribute(prefix, "metgram_flag_colour", colour_, params);
	setAttribute(prefix, "metgram_flag_frequency", frequency_, params);
	setAttribute(prefix, "metgram_flag_length", length_, params);
}

void MetgramFlagsAttributes::copy(const MetgramFlagsAttributes& other)
{
	setColour(other.colour_->clone());
	frequency_ = other.frequency_;
	length_ = other.length_;
} 


bool MetgramFlagsAttributes::accept(const string& node)
{	
	if ( magCompare(node, "metflags")  )
		return true;
	return false;
}

void MetgramFlagsAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "metflags") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void MetgramFlagsAttributes::print(ostream& out)  const
{
	out << "MetgramFlagsAttributes[";
	out << "colour = " << *colour_;
	out << ", frequency = " << frequency_;
	out << ", length = " << length_;
	out << "]" << "\n";
}


void MetgramFlagsAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tmetgram_flag_colour = \'" << *colour_ << "\'\n";
	out << tab << "\tmetgram_flag_frequency = \'" << frequency_ << "\'\n";
	out << tab << "\tmetgram_flag_length = \'" << length_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> metgram_flag_colour("metgram_flag_colour", "red", "");
static MagicsParameter<int> metgram_flag_frequency("metgram_flag_frequency", 1, "");
static MagicsParameter<double> metgram_flag_length("metgram_flag_length", 0.5, "");
