/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file DayMethodComposition.h
    \brief Definition of the Template class DayMethodComposition.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 10-Oct-2005
    
    Changes:
    
*/

#ifndef DayMethodComposition_H
#define DayMethodComposition_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"
#include "AxisItem.h"


namespace magics {

class DayMethodComposition {

public:
	DayMethodComposition();
	virtual ~DayMethodComposition();
    
    virtual void set(const XmlNode&) {
        Log::dev() << "(const XmlNode&)---> to be checked!...\n";
    }
    virtual void set(const map<string, string>&) {
        Log::dev() << "(const map<string, string&)---> to be checked!...\n";
    }
    virtual bool accept(const string& node) { return magCompare(node, "shortday"); }
    virtual DayMethodComposition* clone() const {
        Log::dev() << "(const map<string, string&)---> to be checked!...\n";
        return new DayMethodComposition();
    }
     virtual void toxml(ostream&, int)  const {}
     
     virtual void operator()(AxisItem& item) const { item.format("%a"); }
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	DayMethodComposition(const DayMethodComposition&);
    //! Overloaded << operator to copy - No copy allowed
	DayMethodComposition& operator=(const DayMethodComposition&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const DayMethodComposition& p)
		{ p.print(s); return s; }

};

class FullDayMethodComposition : public DayMethodComposition 
{
public:
	FullDayMethodComposition() {}
	~FullDayMethodComposition() {}
	bool accept(const string& node) { return magCompare(node, "longday"); }
	DayMethodComposition* clone() const {      
        return new FullDayMethodComposition();
    }
    virtual void operator()(AxisItem& item) const { item.format("%A"); }
};   

class OneDayMethodComposition : public DayMethodComposition 
{
public:
	OneDayMethodComposition() {}
	~OneDayMethodComposition() {}
	bool accept(const string& node) { return magCompare(node, "veryshort"); }
	OneDayMethodComposition* clone() const {      
        return new OneDayMethodComposition();
    }
    virtual void operator()(AxisItem& item) const { item.format("%a"); }
};   


template <>
class Translator<string, DayMethodComposition> { 
public:
	DayMethodComposition* operator()(const string& val )
	{
		return SimpleObjectMaker<DayMethodComposition>::create(val);
	}     

	DayMethodComposition* magics(const string& param)
	{
		DayMethodComposition* object;
		ParameterManager::update(param, object);
		return object;
	}
};

} // namespace magics
#endif
