/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file DayDateAxis.cc
    \brief Implementation of the Template class DayDateAxis.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 10-Oct-2005
    
    Changes:
    
*/



#include "DayDateAxis.h"

using namespace magics;

DayDateAxis::DayDateAxis() 
{
	labelColour_ = colour_;
	labelHeight_ = height_;
}


DayDateAxis::~DayDateAxis() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void DayDateAxis::print(ostream& out)  const
{
	out << "DayDateAxis[";
	out << "]";
}

void DayDateAxis::label(AxisItem& item)  const
{
	
	item.colour( item.sunday()  ? "red" : colour_);
	(*composition_)(item);
	
	
	item.format("%e");
	item.height(height_);
	string in = item.label();	
	string out;
	for ( string::iterator x = in.begin(); x != in.end(); ++x)
		if (!isspace(*x)) out.push_back(*x); 
	
	item.label(out);
}

void BothDayDateAxis::label(AxisItem& item)  const
{
	item.colour( item.sunday()  ? "red" : colour_);
	item.format("%a %e");
	item.height(height_);
	//return item.label();
}

void NumberDayDateAxis::label(AxisItem& item)  const
{
	item.colour( (item.sunday() ) ? "red" : colour_);
	item.format("%e");	
	//return item.label();
}


void DateAxisManipulator::labels(vector<AxisItem*>& items)
{
	int first = 0;
	int last = 0;
	
	string previous;
	
	for (vector<AxisItem*>::iterator item = items.begin(); item != items.end(); ++item)  {	
		label(**item);
		string lab = (*item)->label();
		if ( previous == "") {
			previous = lab;
			last++;
			(**item).label("");
			continue;
		}
		if ( previous == lab ) {	
			last++;		
			(**item).label("");
			continue;
		}
		previous = lab;
		int index = first + (((last-1)-first)/2);
		AxisItem* date = items[index]->clone();
		
		double left = items[first]->position();
		double right = items[(last-1)]->position();
		//Log::dev()<< "from " << left << " to " << right << "---->" << (right-left)/2 << endl;
		
		date->position(left + ((right-left)/2) ); // we put in in the middle...
		//date->position(left);
		label(*date);
		string name =  date->label();
		if ( index == 0 ) {
			// here, if the label is too long we can have an overlay..
			// we put only if the size of the label is small ddd DD =(6)
			Log::debug() << "label--->" << name << "(" << name.size() << ")\n";
			if ( name.size() > 6 ) name = "";
		}
		 
		
		date->label(name);
		
		date->height(labelHeight());
		
	
		date->level(position_);		
		(**item).label("");
		push_back(date);		 
		first = last;
		last++;
	}
	
	// Just in case do the last one!
	

	unsigned int index = first + ((last-first)/2);

	

	if (index < items.size() ) {
		AxisItem* date = items[index]->clone();
		
		date->level(position_);		
		label(*date);
		push_back(date);		 
	}
}
